#pragma once

#include <saas/library/daemon_base/module/module.h>

#include <library/cpp/object_factory/object_factory.h>

class TRtyOpsConfig: public TPluginConfig<IDaemonModuleConfig> {
protected:
    virtual void DoInit(const TYandexConfig::Section& componentSection) override;
    virtual bool DoCheck() const override;
    virtual void DoToString(IOutputStream& so) const override;

public:
    TString Mode;
    TString VirtualArgs;
    TString Queries;
    TString LocalHostName;
    ui16 BasePort = 0;
};

class TRtyOpContext {
public:
    TString Host;
    ui16 Port;
};

class IRtyOpHost {
public:
    virtual ~IRtyOpHost() = default;

    virtual void InitContext(TRtyOpContext& ctx) const = 0;

    virtual const TRtyOpsConfig& GetConfig() const = 0;
};

class IRtyOp: public TThrRefBase {
public:
    using TFactory = NObjectFactory::TObjectFactory<IRtyOp, TString>;

public:
    virtual void Init(IRtyOpHost& host) = 0;

    virtual void Prepare() = 0;
    virtual void Run(IRtyOpHost& host) = 0;
};
