#pragma once

#include "model.h"

constexpr TStringBuf RtyOpsModuleName = "RTYOPS";

class TRtyOpsModule: public IDaemonModule, public IRtyOpHost /*, public NMessenger::IMessageProcessor*/ {
public:
    TRtyOpsModule(const IServerConfig& serverConfig);

    virtual bool Start(const TStartContext& context) override;

    virtual bool Stop(const TStopContext& context) override;

    virtual TString Name() const override {
        return NameStatic();
    }

public:
    void InitContext(TRtyOpContext& ctx) const override;

    const TRtyOpsConfig& GetConfig() const override {
        return ModuleConfig;
    }

private:
    const TRtyOpsConfig& ModuleConfig;

    TRtyOpContext DefaultOpContext;

    TIntrusivePtr<IRtyOp> Op;

public:
    static bool IsSupportedMode(const TString& mode);

    static TString NameStatic() {
        static const TString name(RtyOpsModuleName);
        return name;
    }
};
