#pragma once

#include <util/generic/strbuf.h>
#include <util/generic/vector.h>
#include <util/stream/str.h>

class TVirtualArgs final {
private:
    TVector<TString> ArgsStorage;
    TVector<const char*> ArgV;

public:
    static int SplitArgsLikeGdb(int argc, char* argv[], TString& s);

    static void Unescape(TStringStream& o, const TStringBuf part);

    static TStringBuf NextTokEscaped(TStringBuf& escapedVar);

public:
    TVirtualArgs(TStringBuf escapedVar);

    void GetArgs(int& argc, const char**& argv) const;
};
