#include "index.h"

#include <saas/protos/rtyserver.pb.h>
#include <saas/library/searchserver/neh.h>
#include <saas/library/indexer_protocol/protocol.h>

#include <saas/protos/reply.pb.h>

#include <library/cpp/neh/factory.h>
#include <library/cpp/neh/location.h>

class TIndexEmulatorClient: public TNehEmulatorRequest {
public:
    TIndexEmulatorClient(TEmulatorServer& owner, NNeh::IRequestRef req)
        : TNehEmulatorRequest(owner, req)
    {
        NRTYServer::TMessage message;
        NRTYServer::TReply reply;
        reply.SetStatus(NRTYServer::TReply::OK);
        VERIFY_WITH_LOG(message.ParseFromArray(Req->Data().data(), Req->Data().size()), "Incorrect message");
        reply.SetMessageId(message.GetMessageId());
        reply.SerializeToArcadiaStream(&DataSaver);
    }
};


void TIndexEmulatorServer::OnRequest(NNeh::IRequestRef req) {
    Add(new TIndexEmulatorClient(*this, req));
}

TIndexEmulatorServer::TIndexEmulatorServer(const TEmulatorServerConfig& config)
    : TEmulatorServer(config)
{
    Path = NRTYServer::IndexingNehScheme + "://127.0.0.1:" + ToString(config.Server.Port) + "/";
    NNeh::TParsedLocation par(Path);
    Requester = NNeh::ProtocolFactory()->Protocol(NRTYServer::IndexingNehProtocol)->CreateRequester(this, par);
}

