#pragma once

#include "server.h"
#include "index.h"

#include <saas/library/searchserver/neh.h>
#include <saas/protos/rtyserver.pb.h>

#include <search/idl/meta.pb.h>


struct TEmulatorConfig : public IServerConfig {
    TEmulatorServerConfig Search;
    TEmulatorServerConfig Index;
    TEmulatorServerConfig Controller;
    const TDaemonConfig& DaemonConfig;

    const TDaemonConfig& GetDaemonConfig() const {
        return DaemonConfig;
    }

    TSet<TString> GetModulesSet() const {
        return TSet<TString>();
    }

    TEmulatorConfig(const TServerConfigConstructorParams& params);
};

class TSearchEmulatorServer : public TEmulatorServer, public THttpServer::ICallBack {
public:
    TSearchEmulatorServer(const TEmulatorServerConfig& config);
    virtual bool Start() override;
    void Stop() override;
    virtual TClientRequest* CreateClient() override;

private:
    class TNehServer : public TSearchNehServer {
    public:
        TNehServer(TSearchEmulatorServer* owner);
        virtual TAutoPtr<IObjectInQueue> DoCreateClientRequest(ui64, NNeh::IRequestRef req) final override;
    private:
        TSearchEmulatorServer* Owner;
    };

    NMetaProtocol::TReport GenerateReport() const;
    THttpServerOptions GetNehOptions() const;

private:
    THttpServer HttpServer;
    TNehServer NehServer;
    NMetaProtocol::TReport ReplyPrototype;
};

class TControllerEmulatorServer : public TEmulatorServer, public THttpServer::ICallBack {
public:
    TControllerEmulatorServer(const TEmulatorConfig& config);
    virtual bool Start() override;
    void Stop() override;
    virtual TClientRequest* CreateClient() override;

private:
    THttpServer HttpServer;
    const TEmulatorConfig& ConfigAll;
};


class TEmulator : public IServer {
public:
    typedef TEmulatorConfig TConfig;
    typedef TCollectServerInfo TInfoCollector;

public:
    TEmulator(const TConfig& config);
    void Run();
    void Stop(ui32 /*rigidStopLevel*/, const TCgiParameters* /*cgiParams*/);
    const TConfig& GetConfig() const {
        return Config;
    }

private:
    bool IsActive;
    const TConfig& Config;
    TIndexEmulatorServer IndexServer;
    TSearchEmulatorServer SearchServer;
    TControllerEmulatorServer ControllerServer;
};
