#pragma once

#include "parsers.h"

#include <saas/library/check_message/check_message.h>
#include <saas/library/daemon_base/config/daemon_config.h>
#include <saas/library/persqueue/telemetry/telemetry.h>
#include <saas/library/persqueue/writer/shards_info.h>
#include <saas/library/tvm/tvm.h>

#include <kikimr/persqueue/sdk/deprecated/cpp/v2/persqueue.h>

#include <library/cpp/logger/global/global.h>

#include <library/cpp/yconf/conf.h>

namespace NSaasPush {
    struct TServiceInfo {
        TString Name;
        TString Ctype;
        TString Alias;
        EMessageFormat Format;
        bool LoggingEnabled = true;

        NSaas::TTvmConfig TvmConfig;

        TDuration ConnectionTimeout = TDuration::Seconds(10);
        TDuration WriteTimeout = TDuration::Minutes(1);
        ui32 AttemptsCount = 1;

        TString TopicsDir;
        TString Server;
        TString SourceIdPrefix;
        std::optional<NPersQueueCommon::ECodec> Codec;

        NSaas::TCheckMessageSettings CheckMessageSettings;

        TServiceInfo();

        void Init(const TYandexConfig::Section* section);
        void Print(IOutputStream& so) const;
    };

    struct TWriterConfig {
        TDaemonConfig::THttpOptions HttpOptions;
        TString MessagesLog;

        TDuration SleepOnConnectFailure = TDuration::Seconds(5);

        TVector<TServiceInfo> Services;

        void Init(const TYandexConfig::Section* config);
        void Print(IOutputStream& so) const;
    };

    struct TControllerConfig {
        TDaemonConfig::THttpOptions HttpOptions;

        void Init(const TYandexConfig::Section* config);
        void Print(IOutputStream& so) const;
    };

    struct TServerConfig {
        ELogPriority LogLevel = TLOG_INFO;
        TString Log;
        TString LogbrokerLog;
        TString TvmLog;

        NPersQueue::TPQLibSettings PQLibSettings;
        TVector<NSaas::TSearchMapInputSettings> SearchMapSettings;
        TDuration UpdateSearchMapPeriod = TDuration::Hours(1);

        TWriterConfig WriterConfig;
        void Init(const TYandexConfig::Section* config);
        void InitLog(const TYandexConfig::Section* config);
        void InitPQLibSettings(const TYandexConfig::Section* config);
        void TryInitWithOldFormat(const TYandexConfig::Section* config);
        void Print(IOutputStream& so) const;
        void PrintPQLibSettings(IOutputStream& so) const;

        bool ParsedFromOldFormat = false;
    };

    class TSaasPushTelemetryConfig : public NSaas::TTelemetryConfig {
    public:
        void Init(const TYandexConfig::Section* section) override;
        void Print(IOutputStream& so) const override;

        const TString& GetAlias() const;
    private:
        TString Alias;
    };

    struct TConfig {
        TControllerConfig ControllerConfig;
        TSaasPushTelemetryConfig TelemetryConfig;
        TServerConfig ServerConfig;

        void Init(const TYandexConfig& parsedConfig);
        void Print(IOutputStream& so) const;
    };
}
