#include "daemon.h"
#include "yt.h"

#include <library/cpp/getopt/modchooser.h>
#include <library/cpp/logger/global/global.h>

int main(int argc, const char* argv[]) {
    try {
        TModChooser mod;

        mod.AddMode("daemon", &DaemonMain, "Run HTTP daemon");
        mod.AddMode("yt", &YtMain, "Push messages from YT table to LB");
        mod.SetDefaultMode("daemon");
        return mod.Run(argc, argv);
    } catch (...) {
        ERROR_LOG << "Error: " << CurrentExceptionMessage() << Endl;
        return 1;
    }
}
