#include "parsers.h"

#include <saas/util/json/json.h>

namespace NSaasPush {
    namespace {
        TActionPtr ParseProto(const TString& data) {
            NRTYServer::TMessage message;
            Y_ENSURE(message.ParseFromString(data));
            return MakeAtomicShared<NSaas::TAction>(message);
        }

        TActionPtr ParseJson(const TString& data) {
            NJson::TJsonValue json;
            Y_ENSURE(NUtil::JsonFromString(data, json));
            TActionPtr action = MakeAtomicShared<NSaas::TAction>();
            action->ParseFromJson(json);
            return action;
        }
    }

    TDataParser CreateDataParser(EMessageFormat messageFormat) {
        switch (messageFormat) {
            case EMessageFormat::Json: return ParseJson;
            case EMessageFormat::Proto: return ParseProto;
            default: ythrow yexception() << "Uknown message format: " << messageFormat;
        }
    }
}
