#pragma once

#include <saas/library/index_snapshot/snapshot_manager.h>

#include <library/cpp/getopt/last_getopt.h>

struct TOptions {
    enum class ECommand {
        ListTimestamps /* "list_timestamps" */,
        ListShards /* "list_shards" */,
        FetchShard /* "fetch_shard" */,
        ListGroupedResources /* "list_grouped_resources" */,
    };

    ECommand Command;

    bool Verbose = false;
    TString SnapshotManager = "yt";
    IIndexSnapshotManager::TContext SnapshotManagerContext;
    ui64 Timestamp = 0;
    TString ShardId;
    ui64 ShardMin, ShardMax;
    TString DstDir;

    void BindToOpts(NLastGetopt::TOpts& opts);
    void PostProcess(TVector<TString> freeArgs);
};
