# -*- coding: utf-8 -*-
import os
import yaml


def read_configuration(config_file):
    """
    Read configuration file in yaml format
    """
    try:
        with open(config_file) as cf:
            config = yaml.safe_load(''.join(cf.readlines()))
        return config
    except EnvironmentError as e:
        raise Exception('Cannot open/parse config file={} error: {}'.format(config_file, e))


def write_configuration(config_file, config_data):
    """
    Write configuration file in yaml format
    """
    try:
        with open(config_file, 'w') as cf:
            yaml.dump(config_data, cf)
        os.chmod(config_file, 0o0600)
    except EnvironmentError as e:
        raise Exception('Cannot open/parse config file={} error: {}'.format(config_file, e))
