#pragma once

#include <mapreduce/yt/interface/fwd.h>

#include <util/generic/hash.h>
#include <util/generic/map.h>
#include <util/ysaveload.h>

struct TRTYServerConfig;
class TFsPath;

struct TYTConfigFiles {
    void Init(const TString& configPath, const TString& dictPath);
    void AttachPath(const TString& path);
    void FillSpecFiles(NYT::TUserJobSpec& jobSpec) const;

private:
    void DoAttachPath(const TFsPath& jobPath, const TFsPath& localPath);
    void AttachFile(const TFsPath& jobPath, const TFsPath& localPath);

    bool DoUseFiles = false;
    TMap<TString, TString> TransmitFiles;
};

struct TRtyConfigBundle {
    TString Text;
    THashMap<TString, TString> Variables;

    Y_SAVELOAD_DEFINE(Text, Variables);

    THolder<TRTYServerConfig> Parse() const;
};
