#pragma once

#include <saas/protos/rtyserver.pb.h>

#include <util/folder/filelist.h>
#include <util/generic/string.h>

class IDocumentBuilder {
public:
    IDocumentBuilder() = default;
    virtual ~IDocumentBuilder() = default;
    virtual bool GetNext(NRTYServer::TMessage::TDocument& document) = 0;
};

class IFileDocumentBuilder : public IDocumentBuilder {
public:
    IFileDocumentBuilder(const TString& dirname, const TString& suffix);
    virtual ~IFileDocumentBuilder() = default;

    bool GetNext(NRTYServer::TMessage::TDocument& document) override;

protected:
    virtual void ReadFile(const TString& filepath, NRTYServer::TMessage::TDocument& document) = 0;

private:
    TString Dirname;
    TFileList FileList;
};

class TActionFileDocumentBuilder : public IFileDocumentBuilder {
public:
    TActionFileDocumentBuilder(const TString& dirname, const TString& suffix)
        : IFileDocumentBuilder(dirname, suffix)
    {}
    virtual ~TActionFileDocumentBuilder() = default;

protected:
    void ReadFile(const TString& filepath, NRTYServer::TMessage::TDocument& document) override;
};

class TMsgDocFileDocumentBuilder : public IFileDocumentBuilder {
public:
    TMsgDocFileDocumentBuilder(const TString& dirname, const TString& suffix)
        : IFileDocumentBuilder(dirname, suffix)
    {}
    virtual ~TMsgDocFileDocumentBuilder() = default;

protected:
    void ReadFile(const TString& filepath, NRTYServer::TMessage::TDocument& document) override;
};
