#pragma once

#include <saas/rtyserver/indexer_core/merger_interfaces.h>
#include <saas/rtyserver/merger/m2n_decoder.h>

#include <util/string/vector.h>

class TMergeMoveTask: public IMergerTask {
public:
    TMergeMoveTask(const TRTYServerConfig& config, IIndexStorage& storage, TVector<TString> sourceSegments, TString workingDirectory, TString destSegment);
    virtual ~TMergeMoveTask() = default;

    void MoveFromTemp(ui32 destIndex, IIndexStorage& /*storage*/, const std::atomic<bool>* /*rigidStop*/) override;
    const TVector<TString>& GetSourceSegments() const override;
    const TVector<TString>& GetDestSegments() const override;

    TRTYMerger::IRTYMergerDocIdDecoder* GetDecoder() override {
        return static_cast<TRTYMerger::IRTYMergerDocIdDecoder*>(Decoder.Get());
    }
    TRTYMerger::IRTYMergerDocIdInfo* GetInfo() override {
        return nullptr;
    }
    int GetShardNumber() const override {
        FAIL_LOG("NOT APPLICABLE METHOD");
    }
    TString GetName() const override {
        return "merge_move_" + DestSegments[0];
    };
    bool NeedWriteSourceIndexes() const override {
        return false;
    }
    bool GetIsPortions() const override {
        return false;
    }

protected:
    TString DoBuildTempDest(IIndexStorage& storage, const TString& segment) const override;
    TString DoBuildFullDest(IIndexStorage& storage, const TString& segment) const override;
    void DoBuildDecoder(IIndexStorage& storage) override;
    bool DoOnStart(const std::atomic<bool>* /*rigidStop*/) override;
    void DoOnBeforeMainStage() override;
    void DoOnFinished(const std::atomic<bool>* /*rigidStop*/) override;
    void DoOnFailed() override;

private:
    TString GetTempDir() const;

private:
    const TRTYServerConfig& Config;
    IIndexStorage& Storage;
    const TString WorkingDirectory;
    const TVector<TString> SourceSegments;
    const TVector<TString> DestSegments;
    THolder<TM2NDecoder> Decoder;
};
