#pragma once

#include "document_builder.h"
#include <saas/tools/standalone_indexer/lib/standalone_indexer.h>

#include <saas/protos/rtyserver.pb.h>

#include <library/cpp/getopt/last_getopt.h>

class TLocalIndexer {
public:
    struct TOptions {
        TString SrcDir;                  // path to local directory with protobuf document files
        TString SrcType = "msgdoc";      // type of input: msgdoc (protobuf), action (json)
        TString SrcSuffix = "";          // file suffix to match in LocalSrcDir (e.g. ".json")

        bool DoMerge = false;           // merge index segments after indexing

        void BindToOpts(NLastGetopt::TOpts& opts);
    };

public:
    TLocalIndexer(TString configText, const TOptions& options);
    void Run();

private:
    const TOptions Options;
    THolder<IDocumentBuilder> Builder;
    TString ConfigText;
};

