#pragma once

#include "yt_command.h"

#include <saas/library/index_snapshot/snapshot_manager.h>
#include <saas/library/yt/common/shard.h>
#include <saas/library/st_indexer_report/cpp/yt_report.h>

#include <mapreduce/yt/interface/fwd.h>

#include <util/datetime/base.h>
#include <util/generic/hash_set.h>
#include <util/generic/ptr.h>
#include <util/generic/string.h>


class TPublishCommand : public TYTCommand {
public:
    struct TContext {
        TString SearchMapText;
        TString ServiceName;
        TInstant Timestamp;
        TString CommandLine;
        TInputs SrcDocs;
        TString SnapshotManager;
        IIndexSnapshotManager::TContext SnapshotManagerContext;
        bool EnableSkyShare = false;
    };

    using TShardIdSet = THashSet<TShardId>;

public:
    TPublishCommand(TInputs inputs, TOutputs outputs, bool verbose, NSaas::TYTLaunchReport& report, TContext context);
    virtual ~TPublishCommand();

protected:
    virtual void DoPrepareSpec() override;
    virtual void DoRun(NYT::IClientBase* client) override;

private:
    const TContext Context;
    THolder<IIndexSnapshotManager> SnapshotManager;
    TShardIdSet ShardsSet;
};
