import argparse
from saas.library.python.awacs import namespace
from saas.tools.devops.lib23.saas_entity import saas_service_iterator


def parse_args():
    p = argparse.ArgumentParser()

    subparsers = p.add_subparsers(help='help for subcommand', dest='command')
    alone_parser = subparsers.add_parser('single', help='single help')
    alone_parser.add_argument('-s', '--service')
    alone_parser.add_argument('-c', '--ctype')
    alone_parser.add_argument('-t', '--timeout-from-sla', default=False)

    all_parser = subparsers.add_parser('all', help='all help')
    all_parser.add_argument('-c', '--ctype')
    return p.parse_args()


def update_services_upstreams(*args, **kwargs):
    services = saas_service_iterator(*args, **kwargs)
    ns = namespace.NamespaceManager()
    for service in services:
        ns.set_upstreams_for_service(service.name, service.ctype, timeout_from_sla=False)

args = parse_args()
if args.command == "all":
    update_services_upstreams(saas_ctypes=[args.ctype])
else:
    namespace.NamespaceManager().set_upstreams_for_service(args.service, args.ctype, args.timeout_from_sla)
