<?php

function make_task_info($json) {
    global $full_report_cgi;
    $sequence = $json->{"script"}->{"graph"}->{"vertices"};
    $tasks = $sequence;
    $result = array();
    foreach ($sequence as $task) {
        $task_name = $task->{"name"};
        $result["full_by_id"][$task_name] = $task->{"task"};
        $action = $task->{"task"}->{"action"};
        $result_task = $action->{"result"};
        $is_remote = (bool) $task->{"task"}->{"is_remote"};
        if (array_key_exists("id_task", $action) && ($result_task->{"status"} != "SUCCESS" || $full_report_cgi === "yes") && !$is_remote) {
            $result[$task_name] = build_task_info($result_task->{"status"}, $action->{"id_task"});
        } else {
            $result[$task_name] = $result_task->{"status"};
            if (array_key_exists("hr_info", $result_task)) {
                $result[$task_name] = $result[$task_name] . ": " . $result_task->{"hr_info"};
            }
            if (array_key_exists("time_start", $result_task) && array_key_exists("time_finish", $result_task)) {
                $time_start = (int) $result_task->{"time_start"};
                $time_finish = (int) $result_task->{"time_finish"};
                $result[$task_name] = $result[$task_name] . " (" . (string) ($time_finish - $time_start) . "ms)";
            }
        }
    }
    return $result;
}

function build_task_info($status, $task_id) {
    global $ctype_cgi;
    global $service_cgi;
    $result = array();

    $inclFilter=
        "is_finished|" .
        "script|" .
        "script\.graph|" .
        "script\.graph\.vertices|" .
        "script\.graph\.vertices\[.*\]|" .
        "script\.graph\.vertices\[.*\]\.name|" .
        "script\.graph\.vertices\[.*\]\.task|" .
        "script\.graph\.vertices\[.*\]\.task.\action|" .
        "script\.graph\.vertices\[.*\]\.task.\action\.id_task|" .
        "script\.graph\.vertices\[.*\]\.task.\action\.result|" .
        "script\.graph\.vertices\[.*\]\.task.\action\.result\.status|" .
        "script\.graph\.vertices\[.*\]\.task.\action\.result\.hr_info|" .
        "script\.graph\.vertices\[.*\]\.task\.is_remote";

        $exclFilter=
        "script\.graph\.vertices\[.*\]\.task\.action\.task|" .
        "script\.graph\.edges";

    if (read_reply_from_dm("deploy_info?ctype=$ctype_cgi&service=$service_cgi&id=$task_id&exclusion_filter=$exclFilter&inclusion_filter=$inclFilter", $reply_text)) {
        $json = json_decode($reply_text);
        if ($json === NULL) {
            return $reply_text;
        }
        $result["ID"] = $task_id;
        if ($json != NULL && array_key_exists("is_finished", $json)) {
            $result["is_finished"] = (bool) $json->{"is_finished"};
            $result["script"] = make_task_info($json);
        } else {
            $result["is_finished"] = true;
            $result["script"]["info"] = "PARSE FAILED";
        }
    } else {
        $result = "$status:$reply_text";
    }
    return $result;
}

function table_report($task_data) {
    if (is_array($task_data) && array_key_exists("ID", $task_data)) {
        $result = "<table class='cluster_structure' >";
        $id = $task_data["ID"];
        $direct = $task_data["script"];
        $result .= "<tr><td colspan=\"2\" ><a href=\"" . get_dm_url() . "deploy_info?id=$id\">ID=\"$id\"</a></td></tr>";
        foreach ($direct as $key => $value) {
            if ($key !== "full_by_id") {
                $result .= "<tr>";
                $result .= "<td>$key</td>";
                $result .= "<td>" . table_report($value) . "</td>";
                $result .= "</tr>";
            }
        }
        $result .= "</table>";
        return $result;
    } else {
        $info = json_encode($task_data);
        if (substr($info, 0, 8) === "\"SUCCESS")
            $info = "<span style=\"color:#090;text-align:left;\">$info</span>";
        else if (substr($info, 0, 5) === "\"FAIL")
            $info = "<span style=\"color:#900;text-align:left;\">$info</span>";
        return $info;
    }
}

function tree_report($task_data) {

    $treeArray = array(); /*
      if (array_key_exists("ID", $task_data)) {
      $id = json_encode($task_data["ID"]);
      $direct = $task_data["direct"];
      $currArray = array();
      $i = 0;
      foreach ($direct as $key => $value) {
      $currArray[$i]["row"] = array ("prop" => $key, "value" => "sdsd");
      $i++;
      }
      $treeArray[0]["row"] = array ("prop" => "id", "value" => $id);
      $treeArray[0]["children"] = $currArray;
      } else {
      return json_encode($task_data);
      } */
    $info = array(
        'id' => 'KoolTreeGrid1',
        'width' => '660px',
        'keepSate' => false,
        'columns' => array(
            array(
                'field' => 'prop',
                'headerText' => 'Property',
                'width' => '200px',
            ),
            array(
                'field' => 'value',
                'headerText' => 'Value',
                'width' => '150px',
            )
        )
    );

    $treeGrid = KoolTreeGrid::newTreeGrid($info);
    $treeGrid->set(array(
        'TreeArray' => array("children" => $treeArray)
    ));

    $treeGrid->process();
    return json_encode($treeGrid);
}

function task_check($task_id) {
    try {
        if ($task_id == "") {
            return '{"report": "", "is_finished": true, "id_task": ""}';
        } else {
            $task_data = build_task_info("START", $task_id);
            $result = table_report($task_data);
            $is_finished = array_key_exists("is_finished", $task_data) && (bool)$task_data["is_finished"];
            $reply = array("report" => $result, "is_finished" => $is_finished, "id_task" => $task_id);
            return json_encode($reply);
        }
    } catch(Exception $e) {
        return '{"report": "' . $e->getMessage() . '", "is_finished": true, "id_task": ""}';
    }
}

?>
