<script type="text/javascript">
    function renewTable() {
        document.getElementById("files_table").innerHTML = "Loading...";
        koolajax.callback(get_request_from_dm("get_files?ctype=<?php echo $ctype_cgi ?>&service_type=" + document.getElementById("service_type").value), onFilesInfoGet);		
    }
    window.onload = function() {
         renewTable();
    }
    var colors = ["white","#FFCCCC","#CCFFCC","#CCCCFF"];

    function onFilesInfoGet(s) {
        var table = document.getElementById("files_table");
        if (!s.success) {
            table.innerHTML = s.reply;
            return;
        }
        data = JSON.parse(s.reply);
        var result = "<table  border='1'><tr><th>Service</th><th>Nanny Service</th><th>GenConf Groups</th>";
        if ("files" in data)
            for (var f = 0; f < data.files.length; ++f)
                result += "<th>" + data.files[f] + "</th>";
        result += "</tr>";
        if ("services" in data) {
            for (service in data.services) {
                result += "<tr><td>" + service + "</td>";
                var serviceData = data.services[service];
                var tags = "";
                var tags_title = "";
                if ("tags" in serviceData) {
                    tags = serviceData.tags.join();
                    tags_title = serviceData.tags.join("\n");
                    if (tags.length > 50)
                        tags = tags.substr(0, 47) + "...";
                    if (serviceData.tags.length == 1)
                        tags = "<a target='_blank' href='https://nanny.yandex-team.ru/ui/#/services/catalog/" + serviceData.tags[0] + "/files'>" + tags + "</a>";
                    if (serviceData.custom_tags)
                        tags = "<b>" + tags + "</b>";
                }
                result += "<td title='" + tags_title + "'>" + tags + "</td>";
                result += "<td><table width='100%'>";
                if ("groups" in serviceData) {
                    for (name in serviceData.groups) {
                        releases = serviceData.groups[name];
                        result += "<tr><td>" + name + "</td><td align=right>";
                        for (var r = 0; r < releases.length; ++r) {
                            if (r > 0)
                                result += "<br>";
                            result += "<a target='_blank' href='https://gencfg.yandex-team.ru/" + releases[r] + "/groups/" + name +"'>" + releases[r] + "</a>";
                        }
                        result += "</td></tr>";
                    }
                }
                result += "</table></td>";
                for (var f = 0; f < data.files.length; ++f) {
                    var file = data.files[f];
                    if ("files" in serviceData && file in serviceData.files) {
                        var fileData = serviceData.files[file];
                        var title = "";
                        for (field in fileData) {
                            if (title != "")
                                title += "\n";
                            title += field + ": " + fileData[field];
                        }
                        result += "<td nowrap='1' style='background-color:" + colors[fileData.color] + ";' title='" + title + "'>";
                        if (fileData.file_type == "sandbox_files") {
                            result += "sb: " + fileData.task_id;
                        } else if (fileData.file_type == "url_files") {
                            result += "url: " + fileData.url;
                        } else {
                            result += fileData.file_type;
                        }
                        result += "</td>";
                    } else {
                        result+= "<td style='background-color:#CCCCCC;'></td>";
                    }
                }
                result += "</tr>";
            }
        }
        result += "</table>";
        table.innerHTML = result;
    }
</script>
<?php
    $files_info = "<select id='service_type' onChange='renewTable()'>";
    $files_info .= "<option>rtyserver</option>";
    $files_info .= "<option>searchproxy</option>";
    $files_info .= "<option>indexerproxy</option>";
    $files_info .= "<option>deploy_manager</option>";
    $files_info .= "</select>";
    $files_info .= "<div id='files_table'></div>";
?>