<?php

$KoolControlsFolder = "../KoolPHPSuite/KoolControls";
require $KoolControlsFolder . "/KoolTreeGrid/kooltreegrid.php";
require $KoolControlsFolder . "/KoolAjax/koolajax.php";
require $KoolControlsFolder . "/KoolForm/koolform.php";
require $KoolControlsFolder . "/KoolComboBox/koolcombobox.php";
require $KoolControlsFolder . "/KoolListBox/koollistbox.php";
require "http-request/HttpRequest.php";

$main_page = parse_url($_SERVER['REQUEST_URI'])["path"];
$base_page = "$main_page?dmhost=$deploy_manager_host&dmup=$deploy_manager_up&dmport=$deploy_manager_port&full_report=$full_report_cgi";
if ($full_interface)
    $base_page .= "&backdoor=1";

function get_dm_url() {
    global $deploy_manager_host, $deploy_manager_port, $deploy_manager_up, $ctype_cgi;
    $dm_host = $deploy_manager_host;
    $dm_port = $deploy_manager_port;
    if ($dm_host == "") {
        if ($ctype_cgi == "" || strpos($ctype_cgi, "stable") === 0) {
            $dm_host = "saas-dm.yandex.net";
        } else {
            $dm_host = "saas-dm-test.yandex.net";
        }
    }
    return "http://$dm_host:$dm_port$deploy_manager_up/";
}

function read_reply_from_dm($request, &$response, $timeout = 30) {
    try {
        $http = HttpRequest::get(get_dm_url() . $request)->
                        connectTimeout(1)->readTimeout($timeout);
        $response = $http->body();
        return ($http->ok() && !empty($response));
    } catch (Exception $e) {
        $response = $e->getMessage();
        return false;
    }
}

function get_request_from_dm($request) {
    $success = read_reply_from_dm($request, $response);
    return ["success" => $success, "reply" => $response];
}

$koolajax->enableFunction("get_request_from_dm");

function read_reply_from_dm_post($request, $post, &$response, $nullOnError) {
    try {
        $http = HttpRequest::post(get_dm_url() . $request)->
                        form($post)->connectTimeout(1)->readTimeout(30);
        if (($nullOnError == null || $nullOnError == true) && !$http->ok())
            $response = null;
        else
            $response = $http->body();
        return $http->ok();
    } catch (Exception $e) {
        $response = $e->getMessage();
        return false;
    }
}

function post_request_to_dm($request, $post, $nullOnError) {
    $success = read_reply_from_dm_post($request, $post, $response, $nullOnError);
    return ["success" => $success, "reply" => $response];
}

$koolajax->enableFunction("post_request_to_dm");

function read_reply_from_mon($request) {
    try {
        $http = HttpRequest::get('http://saas-mon.n.yandex-team.ru/' . $request)->
                        connectTimeout(2)->readTimeout(60);
        $response = $http->body();
        return ["success" => ($http->ok() && !empty($response)), "reply" => $response];
    } catch (Exception $e) {
        $response = $e->getMessage();
        return ["success" => false, "reply" => $response];
    }
}

$koolajax->enableFunction("read_reply_from_mon");

function array_value($array, $key, $default_value = null) {
    return is_array($array) && isset($array[$key]) ? $array[$key] : $default_value;
}

function get_service_url($service_name, $ctype, $service_type, $action) {
    global $base_page;
    return "$base_page&ctype=$ctype&action=$action&service=$service_name&service_type=$service_type&path=/configs/$service_name";
}

?>

<?php

require $KoolControlsFolder . "/KoolTabs/kooltabs.php";

$kts = new KoolTabs("kts");

$kts->styleFolder = $KoolControlsFolder . "/kooltabs/styles/silver";

$correct_dm_host = read_reply_from_dm("ctypes", $ctypes_from_dm);

$services_list = array();
$services_list_loaded = false;

if ($correct_dm_host) {
    $ctypes = json_decode($ctypes_from_dm, true);
    if ($ctypes == null) {
        $ctypes = array();
        $correct_dm_host = false;
    } else {
        $actions = array("cluster_info", "service_cluster_info", "service_info", "cluster_map", "service_plots", "service_wizard","files_info", "sla_info");
        if ($full_interface) {
            array_push($actions, "service_reshard");
        }
        foreach ($ctypes as $ctype) {
            $kts->addTab("root", $ctype, $ctype, "$base_page&ctype=$ctype&action=$action_cgi&service=$service_cgi&service_type=$service_type_cgi&path=$path_cgi", $ctype_cgi == $ctype);
            foreach ($actions as $action) {
                $kts->addTab($ctype, $ctype . $action, $action, "$base_page&ctype=$ctype&action=$action&service=$service_cgi&service_type=$service_type_cgi&path=$path_cgi", $action == $action_cgi);
            }
        }

        $ctypes_global_info = "deploy_manager: <b>" . get_dm_url() . "</b>" . $kts->Render();
    }
}
if (!$correct_dm_host) {
    $ctypes = array();
    $ctypes_global_info = "CANT PING DEPLOY_MANAGER(" . get_dm_url() . ")";
}

function get_services_list() {
    global $ctype_cgi;
    global $action_cgi;
    global $service_cgi;
    global $service_type_cgi;

    global $correct_dm_host;
    global $services_list_loaded;
    global $services_list;

    if ($services_list_loaded && $correct_dm_host) {
        return $services_list;
    }
    if (!read_reply_from_dm("get_services", $services_from_dm)) {
        return $services_list;
    }
    $json = json_decode($services_from_dm, true);
    if ($json != null && array_key_exists($ctype_cgi, $json)) {
        $services_by_ctype = $json[$ctype_cgi];
        foreach ($services_by_ctype as $service_type => $services) {
            $is_proxy = $service_type == "indexerproxy" || $service_type == "searchproxy" || $service_type == "intsearch";
            if ($service_type == "rtyserver")
                $services["unused"] = "";
            foreach ($services as $service_name => $value) {
                $href = get_service_url($service_name, $ctype_cgi, $service_type, $action_cgi);
                if ($service_name != $service_cgi || $service_type != $service_type_cgi) {
                    $link = "<a style=\"color:black\" href=$href>$service_name</a>";
                } else {
                    $link = "<a style=\"color:red\" href=$href>$service_name</a>";
                }
                if ($is_proxy)
                    $services_list["proxy"][$service_name] = $link;
                else
                    $services_list[$service_type][$service_name] = $link;
            }
        }
    }
    $services_list_loaded = true;
    return $services_list;
}

?>
