<?php
include("parse_params.php");
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <link rel="shortcut icon" href="icon.bmp" type="image/bmp">
        <?php
        $titleStr = "SAAS Control";
        if ($ctype_cgi != "") {
            $titleStr = htmlspecialchars($ctype_cgi)." - ".$titleStr;
        }
        if ($service_cgi != "") {
            $titleStr = htmlspecialchars($service_cgi)." - ".$titleStr;
        }
        echo "<title>".$titleStr."</title>";
        ?>

        <style>
            table.cluster_structure {
                border-width: 1px;
                background-color: grey;
                padding: 0px;
                border-spacing: 1px;
            }
            table.cluster_structure td {
                background-color: white;
            }
            table.cluster_structure th {
                background-color: white;
            }

        </style>

    </head>
    <body>

        <?php
        include("frame.php");

        if ($correct_dm_host && $action_cgi !== "")
            include("$action_cgi.php");
        ?>

        <table align="left" border="2" width="100%">
            <tr>
                <td colspan="2">
                    <?php
                    echo $ctypes_global_info;
                    ?>
                </td>
            </tr>
            <tr>
                <td id="services_list_column" rowspan="2" width="20%" valign="top">
                    <?php
                    if ($correct_dm_host) {
                        if (substr($action_cgi, 0, 7) == "service" || $action_cgi == "cluster_info") {
                            $services_list_local = get_services_list();
                            foreach ($services_list_local as $service_type => $services) {
                                echo "<h2>$service_type</h2>";
                                foreach ($services as $key => $value) {
                                    echo "$value<br />";
                                }
                            }
                        }
                    }
                    ?>
                </td>
                <td valign="top">
                    <?php
                    if ($correct_dm_host) {
                        if ($action_cgi == "service_wizard") {
                            echo $service_wizard;
                        }
                        if ($action_cgi == "service_reshard") {
                            echo $reshard_actions;
                        }
                        if ($action_cgi == "files_info") {
                            echo $files_info;
                        }
                    }
                    ?>
                </td>
            </tr>
            <tr>
                <td id="main_info_column" width="80%" valign="top">
                    <?php
                    if ($correct_dm_host) {
                        echo $koolajax->Render();
                        if ($action_cgi == "service_info") {
                            echo getEditor();
                        }
                        if ($action_cgi == "service_cluster_info") {
                            echo renderClusterReport();
                        }
                        if ($action_cgi == "cluster_info") {
                            echo renderClusterReport();
                        }
                        if ($action_cgi == "cluster_map") {
                            echo renderClusterReport();
                        }
                        if ($action_cgi == "service_plots") {
                            echo renderClusterReport();
                        }
                        if ($action_cgi == "sla_info") {
                            echo renderClusterReport();
                        }

                    }
                    ?>
                </td>
            </tr>

        </table>
    </body>
</html>

