
<script src="https://yandex.st/jquery/2.0.3/jquery.min.js"></script>
<style type='text/css'>
.progress {
    margin-bottom: 0px;
}
table {
    border-spacing: 2px;
    border-collapse: separate;
}
</style>
<script type="text/javascript">
    var saved_queues = "";
    var saved_proxies = "";
    var saved_shards = "";
    window.onload = function() {
        disable_links = false;
    }

</script>

<?php

function with_domains($hosts){
    $result = array();
    foreach($hosts as $host){
        $dhost = $host;
        if (strpos($host, ".yandex") === false) {
            $dhost .= ".search.yandex.net";
        }
        array_push($result, $dhost);
    }
    return $result;
}

function without_domains($hosts){
    $result = array();
    foreach($hosts as $host){
        $dhost = str_replace(".search.yandex.net", "", $host);
        array_push($result, $dhost);
    }
    return $result;
}

function get_service_hosts($service){
    global $ctype_cgi;
    $result = array();
    read_reply_from_dm("using_slots?service=$service&ctype=$ctype_cgi", $json_slots_data);
    $slots_data = json_decode($json_slots_data, true);
    foreach($slots_data[$ctype_cgi] as $dc => $slots_arr){
        foreach($slots_arr as $slot){
            array_push($result, $slot["host"]);
        }
    }
    return array_unique($result);
}
function get_signals_serv() {
    global $service_cgi;
    $SERV = "-" . $service_cgi;
    if (strpos($service_cgi, "proxy") !== false or strpos($service_cgi, "deploy_manager") !== false or $service_cgi == "") {
        $SERV = "";
    }
    return $SERV;
}
$periods = array(
    array("hr" => "25m", "sec" => ""),
    array("hr" => "24h", "sec" => "86400000"),
    array("hr" => "week", "sec" => "604800000")
);
$ans_times = array('5', '10', '20', '30', '50', '100', '200', '500', '1000', '2000', 'inf');
$doc_ages = array(60, 5*60, 15*60, 30*60, 3600, 6*3600, 12*3600, 24*3600, 'inf');
$yasm_addr = "http://yasm.yandex-team.ru/chart/";

function get_proxy_ans_times(){
    global $ctype_cgi;
    global $service_cgi;
    global $ans_times;
    $SERV = get_signals_serv();

    $ans_times_str = "";
    foreach($ans_times as $ms){
        $ans_times_str .= "hcount~saas_unistat-times-$ctype_cgi$SERV" . "_dhhh~0~$ms";
        if ($ms != "inf") {
            $ans_times_str .= ",";
        }
    }
    return $ans_times_str;
}

$wait_in_queue_times = [
        ['from'=>0, 'to'=>0.001],
        ['from'=>0.001, 'to'=>0.05],
        ['from'=>0.05, 'to'=>0.075],
        ['from'=>0.075, 'to'=>1],
        ['from'=>1, 'to'=>'inf']
    ];

function get_proxy_wait_in_queue_times() {
    global $ctype_cgi;
    global $service_cgi;
    global $wait_in_queue_times;
    $SERV = get_signals_serv();

    $result = "";
    foreach($wait_in_queue_times as $ms){
        $result .= "hcount~saas_unistat-times-$ctype_cgi" . "-wait_in_queue" . "$SERV" . "_dhhh~" . $ms["from"] . "~" . $ms["to"];
        if ($ms["to"] != "inf") {
            $result .= ",";
        }
    }
    return $result;
}

function get_iproxy_links_arr(){
    global $ctype_cgi;
    global $service_cgi;
    global $doc_ages;
    $SERV = get_signals_serv();

    $result = array();
    $ans_times_str = get_proxy_ans_times();
    
    $ages_s_arr = array();
    foreach($doc_ages as $age) {
        array_push($ages_s_arr, "hcount~saas_unistat-ages-$ctype_cgi$SERV" . "_dhhh~0~" . $age);
    }
    $ages_str = join($ages_s_arr, ',');
    $ages_exp_str = str_replace("ages-$ctype_cgi", "ages-export-$ctype_cgi", $ages_str);
    $ages_def_str = str_replace("ages-$ctype_cgi", "ages-default-$ctype_cgi", $ages_str);
    
    $ans_times_str_perc = str_replace("hcount", "hperc", $ans_times_str);
    
    $ans_times_exp_str = str_replace("times-$ctype_cgi", "times-export-$ctype_cgi", $ans_times_str);
    $ans_times_def_str = str_replace("times-$ctype_cgi", "times-default-$ctype_cgi", $ans_times_str);
    
    $errors_5xx_str = "saas_unistat-index-$ctype_cgi$SERV-5xx_dmmm";
    $errors_4xx_str = str_replace("-5xx_dmmm", "-4xx_dmmm", $errors_5xx_str);
    $errors_3xx_str = str_replace("-5xx_dmmm", "-3xx_dmmm", $errors_5xx_str);
    $ans_202_str = str_replace("-5xx_dmmm", "-202_dmmm", $errors_5xx_str);
    $ans_206_str = str_replace("-5xx_dmmm", "-206_dmmm", $errors_5xx_str);
    $duplicated_str = str_replace("-5xx_dmmm", "-duplicated_dmmm", $errors_5xx_str);

    $infoserv_queue_docs_str = "iproxy_infoserver-$ctype_cgi$SERV-queue_docs_ammv";
    $infoserv_queue_kbytes_str = "iproxy_infoserver-$ctype_cgi$SERV-queue_kbytes_ammv";
    $infoserv_tasks_count_str = "iproxy_infoserver-$ctype_cgi-common-tasks_count_ammv";

    $result["answer by times"] = $ans_times_str;
    $result["perc by times"] = $ans_times_str_perc;
    
    $result["<br>5xx"] = $errors_5xx_str;
    $result["4xx"] = $errors_4xx_str;
    $result["3xx"] = $errors_3xx_str;
    $result["202"] = $ans_202_str;
    $result["206"] = $ans_206_str;
    $result["duplicated"] = $duplicated_str;
    
    $result["<br>default by times"] = $ans_times_def_str;
    $result["export by times"] = $ans_times_exp_str;
    $result["default by ages"] = $ages_def_str;
    $result["export by ages"] = $ages_exp_str;
    
    $result["<br>queue docs"] = $infoserv_queue_docs_str;
    $result["queue kbytes"] = $infoserv_queue_kbytes_str;
    $result["<br>tasks count"] = $infoserv_tasks_count_str;
    return $result;
}

function get_sproxy_links_arr(){
    global $ctype_cgi;
    global $service_cgi;
    $SERV = get_signals_serv();

    $result = array();
    $ans_times_str = get_proxy_ans_times();
    $ans_times_str_perc = str_replace("hcount", "hperc", $ans_times_str);
    $ans_times_str_cache = str_replace("$ctype_cgi$SERV", "$ctype_cgi-cache$SERV", $ans_times_str);
    $ans_times_str_nocache = str_replace("$ctype_cgi$SERV", "$ctype_cgi-chno$SERV", $ans_times_str);
    $ans_cache_vs_no_str = "hcount~saas_unistat-times-$ctype_cgi-cache$SERV" .
        "_dhhh~0~inf,hcount~saas_unistat-times-$ctype_cgi-chno$SERV" . "_dhhh~0~inf";

    $errors_5xx_str = "saas_unistat-search-$ctype_cgi$SERV-5xx_dmmm";
    $errors_4xx_str = str_replace("-5xx_dmmm", "-4xx_dmmm", $errors_5xx_str);
    $errors_timeouted_str = str_replace("-5xx_dmmm", "-timeouted_dmmm", $errors_5xx_str);
    $errors_not_fetched_str = str_replace("-5xx_dmmm", "-not-fetched_dmmm", $errors_5xx_str);
    $errors_exceptions_str = "saas_unistat-search-$ctype_cgi$SERV-exceptions_dmmm";
    
    $ans_count_zero_str = "saas_unistat-search-$ctype_cgi$SERV-count-zero_dmmm";
    $ans_count_zero_perc_str = "perc~saas_unistat-search-$ctype_cgi$SERV-count-zero_dmmm~saas_unistat-search-$ctype_cgi$SERV-200_dmmm";
    
    $result["answer by times"] = $ans_times_str;
    $result["perc by times"] = $ans_times_str_perc;
    
    $result["<br>5xx"] = $errors_5xx_str;
    $result["4xx"] = $errors_4xx_str;
    $result["timeouted"] = $errors_timeouted_str;
    $result["not fetched"] = $errors_not_fetched_str;
    $result["exceptions"] = $errors_exceptions_str;
    
    $result["<br>cached by times"] = $ans_times_str_cache;
    $result["nocache by times"] = $ans_times_str_nocache;
    $result["with&without cache"] = $ans_cache_vs_no_str;
    
    $result["<br>empty results"] = $ans_count_zero_str;
    $result["empty results perc"] = $ans_count_zero_perc_str;
    $result["wait in queue"] = get_proxy_wait_in_queue_times();
    return $result;
}

function get_backend_links_arr(){
    global $ctype_cgi;
    global $service_cgi;
    $result = array();
    
    $ans_times_avg_str = "havg~saas_unistat-search-times-$ctype_cgi-$service_cgi-full_dhhh";
    $med_levels = array(50, 90, 95, 97, 98, 99);
    $meds_arr = array();
    foreach($med_levels as $lev){
        array_push($meds_arr, "quant~saas_unistat-search-times-$ctype_cgi-$service_cgi-full_dhhh~$lev");
    }
    $ans_times_meds_str = join(',', $meds_arr);
    $med_high_levels = array(99, 999, 9997);
    $meds_arr = array();
    foreach($med_high_levels as $lev){
        array_push($meds_arr, "quant~saas_unistat-search-times-$ctype_cgi-$service_cgi-full_dhhh~$lev");
    }
    $ans_times_meds_high_str = join(',', $meds_arr);

    $ans_times_str = get_proxy_ans_times();
    $ans_stimes_str = str_replace("unistat-times", "unistat-search-times", $ans_times_str);
    $ans_full_times_str = str_replace("_dhhh", "-full_dhhh", $ans_stimes_str);
    $ans_full_times_perc_str = str_replace("hcount~", "hperc~", $ans_full_times_str);
    
    $ans_work_times_str = str_replace("-full_dhhh", "-work_dhhh", $ans_full_times_str);
    $ans_queue_times_str = str_replace("-full_dhhh", "-queue_dhhh", $ans_full_times_str);
    $ans_df_times_str = str_replace("$ctype_cgi-$service_cgi", "$ctype_cgi-dfda-$service_cgi", $ans_full_times_str);
    
    $ans_cache_times_str = str_replace("$ctype_cgi-$service_cgi", "$ctype_cgi-cache-$service_cgi", $ans_full_times_str);
    $ans_nocache_times_str = str_replace("$ctype_cgi-$service_cgi", "$ctype_cgi-chno-$service_cgi", $ans_full_times_str);
    $ans_cache_vs_no_str = "hcount~saas_unistat-search-times-$ctype_cgi-cache-$service_cgi-full" . 
        "_dhhh~0~inf,hcount~saas_unistat-search-times-$ctype_cgi-chno-$service_cgi-full" . "_dhhh~0~inf";
    
    $ans_zero_vs_no_str = "saas_unistat-backend-search-$ctype_cgi-$service_cgi-count-zero_dmmm," .
        "saas_unistat-backend-search-$ctype_cgi-$service_cgi-count-nonzero_dmmm";
    $ans_search_errors_str = "saas_unistat-backend-search-$ctype_cgi-$service_cgi-result-fail_dmmm";
    
    $ans_itimes_str = str_replace("unistat-times", "unistat-index-times", $ans_times_str);
    $ans_index_200_str = "saas_unistat-backend-index-$ctype_cgi-$service_cgi-200_dmmm";
    $ans_index_304_str = "saas_unistat-backend-index-$ctype_cgi-$service_cgi-304_dmmm";
    $ans_index_4xx_str = "saas_unistat-backend-index-$ctype_cgi-$service_cgi-400_dmmm";
    $ans_index_5xx_str = "saas_unistat-backend-index-$ctype_cgi-$service_cgi-503_dmmm";

    $df_ages = array('1m', '30m', '1h', '6h', '12h', '24h');
    $df_arr = array();
    foreach($df_ages as $age) {
        array_push($df_arr, "rtyserver_docfetcher_log-backend-df-$service_cgi-$ctype_cgi-age-less-$age");
    }
    $df_ages_str = join(',', $df_arr);
    $df_errors_str = "rtyserver_docfetcher_log-backend-df-$service_cgi-error," . 
        "rtyserver_docfetcher_log-backend-df-$service_cgi-error-400";
    
    $infoserv_queues_str = "rty_infoserver-$service_cgi-$ctype_cgi-queue_mem_ammv,rty_infoserver-$service_cgi-$ctype_cgi-queue_disk_ammv";
    $infoserv_merger_tasks_str = "rty_infoserver-$service_cgi-$ctype_cgi-merger_tasks_ammv";
    $infoserv_sources_count_str = "rty_infoserver-$service_cgi-$ctype_cgi-search_sources_count_ammv";
    $infoserv_sources_count_max_str = "rty_infoserver-$service_cgi-$ctype_cgi-search_sources_count_axxv";
    $infoserv_doccount_str = "rty_infoserver-$service_cgi-$ctype_cgi-docs_in_final_indexes_ammv," .
        "rty_infoserver-$service_cgi-$ctype_cgi-docs_in_memory_indexes_ammv,rty_infoserver-$service_cgi-$ctype_cgi-docs_in_disk_indexers_ammv";
    $infoserv_doccount_tmp_str = "rty_infoserver-$service_cgi-$ctype_cgi-docs_in_memory_indexes_ammv," .
        "rty_infoserver-$service_cgi-$ctype_cgi-docs_in_disk_indexers_ammv";
    $infoserv_age_str = "aver~rty_infoserver-$service_cgi-$ctype_cgi-age_avvv";
    $infoserv_archive_counts_str = "rty_infoserver-$service_cgi-$ctype_cgi-archive_alive_count_ammv," .
        "rty_infoserver-$service_cgi-$ctype_cgi-archive_removed_count_ammv";
    $arch_digits = array('01', '03', '04', '05', '06', '07');
    $arch_docs_arr = array();
    $arch_parts_arr = array();
    foreach($arch_digits as $ad) {
        array_push($arch_docs_arr, "rty_infoserver-$service_cgi-$ctype_cgi-archive-opt-docs-02-" . $ad . "_ammv");
        array_push($arch_parts_arr, "rty_infoserver-$service_cgi-$ctype_cgi-archive-opt-parts-02-" . $ad . "_ammv");
    }
    $infoserv_arch_docs_str = join(',', $arch_docs_arr);
    $infoserv_arch_parts_str = join(',', $arch_parts_arr);

    $infoserv_memreal_str = "aver(rty_infoserver-$service_cgi-$ctype_cgi-mem_size_real_avvv)";
    $infoserv_memvirt_str = "aver(rty_infoserver-$service_cgi-$ctype_cgi-mem_size_virtual_avvv)";
    $infoserv_cpu_str = "aver(rty_infoserver-$service_cgi-$ctype_cgi-cpu_load_user_avvv)";

    $exit_codes = array('', '_1', '_4', '_6', '_9', '_11');
    $exit_codes_arr = array();
    foreach ($exit_codes as $ec) {
        array_push($exit_codes_arr, "crashes_log-saas_$ctype_cgi-$service_cgi" . "_exit_signal" . $ec . "_mmmm");
    }
    $crashes_cnt_str = join(',', $exit_codes_arr);

    $result["replytimes avg"] = $ans_times_avg_str;
    $result["replytimes medians"] = $ans_times_meds_str;
    $result["replytimes high med"] = $ans_times_meds_high_str;

    $result["<br>search-full by times"] = $ans_full_times_str;
    $result["search perc by times"] = $ans_full_times_str;
    $result["search-work by times"] = $ans_work_times_str;
    $result["search-queue by times"] = $ans_queue_times_str;
    $result["search-df by times"] = $ans_df_times_str;
    
    $result["<br>zero&nonzero count"] = $ans_zero_vs_no_str;
    $result["search errors (result=0)"] = $ans_search_errors_str;
    
    $result["<br>search-cache by times"] = $ans_cache_times_str;
    $result["no cache by times"] = $ans_nocache_times_str;
    $result["with&without cache"] = $ans_cache_vs_no_str;
    
    $result["<br>index by times"] = $ans_itimes_str;
    $result["index-200"] = $ans_index_200_str;
    $result["index-304"] = $ans_index_304_str;
    $result["index-400"] = $ans_index_4xx_str;
    $result["index-503"] = $ans_index_5xx_str;
    
    $result["<br>df by ages"] = $df_ages_str;
    $result["df errors"] = $df_errors_str;
    
    $result["<br>indexing queues"] = $infoserv_queues_str;
    $result["merger tasks"] = $infoserv_merger_tasks_str;
    $result["search sources sum"] = $infoserv_sources_count_str;
    $result["search sources max"] = $infoserv_sources_count_max_str;
    $result["docs count"] = $infoserv_doccount_str;
    $result["docs count tmp"] = $infoserv_doccount_tmp_str;
    $result["archive counts"] = $infoserv_archive_counts_str;
    $result["archive docs stat"] = $infoserv_arch_docs_str;
    $result["archive parts stat"] = $infoserv_arch_parts_str;
    $result["last doc age"] = $infoserv_age_str;

    $result["<br>instances memory"] = $infoserv_memreal_str;
    $result["inst virtual mem"] = $infoserv_memvirt_str;
    $result["instances cpu"] = $infoserv_cpu_str;
    $result["crashes"] = $crashes_cnt_str;

    return $result;
}

function do_link($signal, $period_hr){
    global $yasm_addr;
    return "<a href='$yasm_addr$signal' target = '_blank'>$period_hr</a>";
}

function make_links_list($itype, $hosts_str, $signal) {
    global $periods;
    $result = "";
    if ($itype != "common") {
        $result .= " ";
        $result .= do_link("itype=$itype;hosts=ASEARCH;graphs=$signal", "sum");
    }
    foreach($periods as $period){
        $result .= " ";
        $result .= do_link("itype=$itype;hosts=$hosts_str;graphs=$signal/?range=$period[sec]", $period["hr"]);
    }
    return $result;
}

function get_balancer_signals($hosts_names) {
    global $periods;
    $result = "<br>balancer errors";
    $balancer_errors = array();
    foreach($hosts_names as $host) {
        array_push($balancer_errors, "balancer_log-errors-$host");
    }
    $balancer_errors_str = join($balancer_errors, ",");
    $result .= make_links_list("balancer", "ASEARCH", $balancer_errors_str);
    $result .= "<br>";
    return $result;
}

function get_backend_external_signals($hosts_names){
    global $periods;
    global $service_cgi;
    global $ctype_cgi;

    $result = "queues from iproxy";
    $queues_arr = array();
    foreach($hosts_names as $host) {
        array_push($queues_arr, "iproxy_infoserver-queue_docs-h-" . $host . "_ammv");
    }
    $queues_iproxy_str = join($queues_arr, ",");

    $result .= make_links_list("indexerproxy", "ASEARCH", "{$queues_iproxy_str}");

    $result .= "<br>min alive replicas";
    $result .= make_links_list("deploymanager", "ASEARCH", "aver~dm_dashboard-$ctype_cgi-$service_cgi-respond_replics_tvvv");

    $result .= "<br>alive backends count";
    $result .= make_links_list("deploymanager", "ASEARCH", "aver~dm_broadcast-alives-$ctype_cgi-$service_cgi");

    $result .= "<br>laying backends count";
    $result .= make_links_list("deploymanager", "ASEARCH", "aver~dm_broadcast-downs-$ctype_cgi-$service_cgi");

    $result .= "<br>inconsistent replics ratio";
    $result .= make_links_list("deploymanager", "ASEARCH", "aver~dm_dashboard-$ctype_cgi-$service_cgi-inconsistent-ratio_tvvv");

    $result .= "<br>docs in replica";
    $result .= make_links_list("deploymanager", "ASEARCH",
        "{dm_dashboard-$ctype_cgi-$service_cgi-min-replica-docs_tnnv,dm_dashboard-$ctype_cgi-$service_cgi-max-replica-docs_txxv}");

    return $result;
}

function get_hardware_signals($hosts_str){
    global $periods;

    if (strpos($hosts_str, "ASEARCH") !== false) {
        $hosts_str = str_replace("ASEARCH,", "", $hosts_str);
    }

    $result = "hardware";
    $result .= make_links_list("common", $hosts_str, "cpu_perc,iostat_absolute,netstat,netstat_bytes,loadavg,mem_avg,vmstat_perc");

    return $result;
}

function get_proxy_links($proxy){
    global $periods;
    global $ctype_cgi;
    $tag = "";
    if ($proxy == "searchproxy"){
        $tag = "searchproxy";
        $signals = get_sproxy_links_arr();
    } else if ($proxy == "indexerproxy") {
        $tag = "indexerproxydisc";
        if ($ctype_cgi == "stable_kv") {
            $tag = "indexerproxy";
        }
        $signals = get_iproxy_links_arr();
    }

    $result = "";
    $hosts_list_dm = get_service_hosts($proxy);
    $hosts_names = without_domains($hosts_list_dm);
    $hosts = with_domains($hosts_list_dm);
    $hosts_str = "ASEARCH," . join(',', $hosts);

    foreach ($signals as $note => $signal){
        $result .= $note;
        $result .= make_links_list($tag, $hosts_str, "%7B$signal%7D");
        $result .= "<br>";
    }
    $result .= get_balancer_signals($hosts_names);
    $result .= get_hardware_signals($hosts_str);
    return $result;
}

function get_backend_links(){
    global $periods;
    global $service_cgi;
    if (strpos($service_cgi, "proxy") !== false) {
        return "<br>---------";
    }

    $result = "";
    $hosts_list_dm = get_service_hosts($service_cgi);
    $hosts_names = without_domains($hosts_list_dm);
    $hosts = with_domains($hosts_list_dm);
    $hosts_str = "ASEARCH," . join(',', $hosts);

    if (strpos($service_cgi, "deploy_manager") !== false) {
        return get_hardware_signals($hosts_str);
    }

    $signals = get_backend_links_arr();

    foreach ($signals as $note => $signal){
        $result .= $note;
        $result .= make_links_list("rtyserver", $hosts_str, "%7B$signal%7D");
        $result .= "<br>";
    }
    
    $result .= get_backend_external_signals($hosts_names);
    
    $result .= "<br><br>";
    $result .= get_hardware_signals($hosts_str);
    return $result;
}

function renderClusterReport() {
    $report_cluster = "";
    $report_cluster .= "<table style='border-spacing: 6px'><thead><th>searchproxy</th><th>indexerproxy</th><th>backends</th></thead>";
    $report_cluster .= "<tr><td><div id='proxy_states'>";
    $report_cluster .= get_proxy_links('searchproxy');
    $report_cluster .= "</div>";
    $report_cluster .= "</td><td>";
    $report_cluster .= get_proxy_links('indexerproxy');
    $report_cluster .= "";
    $report_cluster .= "</td><td style='vertical-align: top'>";
    $report_cluster .= "<div>";
    $report_cluster .= get_backend_links();
    $report_cluster .= "</div>";
    $report_cluster .= "</td></tr></table>";
    return $report_cluster;
}


$koolajax->scriptFolder = $KoolControlsFolder . "/KoolAjax";
?>
