<script type="text/javascript">
    document.addEventListener('DOMContentLoaded', function(){
        try{
            document.getElementById("services_list_column").setAttribute("width", "1%");
            document.getElementById("main_info_column").setAttribute("width", "95%");
        } catch(err){
            console.log(err);
        }
    });
</script>

<?php

function get_sla_table_json() {
    global $ctype_cgi;
    read_reply_from_dm("get_sla_table?ctype=$ctype_cgi", $json_sla_data);
    return json_decode($json_sla_data, true);
}

function process_multiple_field($json_element, $property_name) {
    if (array_key_exists($property_name, $json_element) && is_array($json_element[$property_name])) {
        return implode(", ", $json_element[$property_name]);
    }
    return "";
}

function make_st_link($value) {
    if ($value == "") {
        return "";
    }
    $url = $value;
    $text = $value;
    if (stristr($value, "https://st.yandex-team.ru/") === false) {
        $url = "https://st.yandex-team.ru/$value";
    } else {
        $text = substr($value, strlen("https://st.yandex-team.ru/"));
    }
    return "<a href=\"" . $url . "\">" . htmlspecialchars($text) . "</a>";
}

function get_service_href_html($service_name) {
    global $ctype;
    if ($ctype == "") {
        return htmlspecialchars($service_name);
    }
    return "<a href=\"" . get_service_url($service_name, $ctype, "rtyserver", "service_cluster_info") ."\">" . htmlspecialchars($service_name) . "</a>";
}


function process_single_field($json_element, $property_name) {
    if (array_key_exists($property_name, $json_element)) {
        return $json_element[$property_name];
    }
    return "";
}

function renderClusterReport() {
    $json_sla = get_sla_table_json();

    $report_cluster = "<table class=\"cluster_structure\"><thead>";
    $report_cluster .= "<tr>";
    $report_cluster .= "<th>Service</th><th>Owners</th><th>Responsibles</th><th>Ticket</th><th>Max Docs</th>";
    $report_cluster .= "<th>Search RPS</th><th>Search RPS Planned</th><th>Index RPS</th><th>Total index size, bytes</th>";
    $report_cluster .= "<th>Search q99, ms</th><th>Search q999, ms</th><th>Unanswers 5 min warn, %</th><th>Unanswers 5 min crit, %</th>";
    $report_cluster .= "<th>Service weight</th>";
    $report_cluster .= "</tr>";
    $report_cluster .= "</thead>";


    foreach($json_sla as $service=>$sla) {
        $report_cluster .= "<tr>";
        $report_cluster .= "<td>". get_service_href_html($service) . "</td>";
        $report_cluster .= "<td>". htmlspecialchars(process_multiple_field($sla, "owners")) . "</td>";
        $report_cluster .= "<td>". htmlspecialchars(process_multiple_field($sla, "responsibles")) . "</td>";
        $report_cluster .= "<td>". make_st_link(process_single_field($sla, "ticket")) . "</td>";
        $report_cluster .= "<td>". htmlspecialchars(process_single_field($sla, "maxdocs")) . "</td>";
        $report_cluster .= "<td>". htmlspecialchars(process_single_field($sla, "search_rps")) . "</td>";
        $report_cluster .= "<td>". htmlspecialchars(process_single_field($sla, "search_rps_planned")) . "</td>";
        $report_cluster .= "<td>". htmlspecialchars(process_single_field($sla, "index_rps")) . "</td>";
        $report_cluster .= "<td>". htmlspecialchars(process_single_field($sla, "total_index_size_bytes")) . "</td>";
        $report_cluster .= "<td>". htmlspecialchars(process_single_field($sla, "search_q_99_ms")) . "</td>";
        $report_cluster .= "<td>". htmlspecialchars(process_single_field($sla, "search_q_999_ms")) . "</td>";
        $report_cluster .= "<td>". htmlspecialchars(process_single_field($sla, "unanswers_5min_perc_warn")) . "</td>";
        $report_cluster .= "<td>". htmlspecialchars(process_single_field($sla, "unanswers_5min_perc_crit")) . "</td>";
        $report_cluster .= "<td>". htmlspecialchars(process_single_field($sla, "service_weight")) . "</td>";
        $report_cluster .= "<td>". htmlspecialchars(process_single_field($sla, "disaster_alerts")) . "</td>";
        $report_cluster .= "</tr>";

    }
    $report_cluster .= "</table>";
    return $report_cluster;
}
?>
