#!/usr/bin/env python
from __future__ import absolute_import
import builtins
import os
import sys
import posix
import saas_deploy

from library.python.django.contrib.staticfiles.storage import ResourceFilesStorage


def get_resfs_mock(orig, mock):
    def _mock(path, *args, **kwargs):
        prefix = sys.executable + '/'
        if path.startswith(prefix):
            return mock(path[len(prefix):])
        return orig(path, *args, **kwargs)
    return _mock


def stat_mock(path, os_stat=os.stat):
    st_size = len(ResourceFilesStorage()._open(path))
    stat = os_stat(sys.executable)
    return posix.stat_result((
        stat.st_mode, stat.st_ino, stat.st_dev,
        stat.st_nlink, stat.st_uid, stat.st_gid,
        st_size,
        stat.st_atime, stat.st_mtime, stat.st_ctime,
    ))

# os.path.exists = get_resfs_mock(os.path.exists, ResourceFilesStorage().exists)
# os.stat = get_resfs_mock(os.stat, stat_mock)
# os.listdir = get_resfs_mock(os.listdir, ResourceFilesStorage().listdir)
# builtins.open = get_resfs_mock(builtins.open, ResourceFilesStorage()._open)


if __name__ == "__main__":
    os.environ.setdefault("DJANGO_SETTINGS_MODULE", "saas_deploy.settings")  # "junk.anikella.saas_deploy_copy.saas_deploy.settings")

    from django.core.management import execute_from_command_line

    execute_from_command_line(sys.argv)
