
function get_cgi_params() {
    let query = window.location.search.split('#')[0];
    let parts = [];
    if (query !== '') {
        parts = query.substring(1).split('&');
    } else {
        return {};
    }
    let params = {};
    for (let i=0; i<parts.length; ++i) {
        let fie_val = parts[i].split('=');
        if (fie_val.length < 2) { continue; }
        params[fie_val[0]] = fie_val[1];
    }
    return params;
}


function set_cgi_param(target_param, target_value) {
    let query = window.location.search.split('#')[0];
    let parts = [];
    if (query !== '') {
        parts = query.substring(1).split('&');
    }
    let has_target = false;
    for (let i=0; i<parts.length; ++i) {
        let fie_val = parts[i].split('=');
        if (fie_val[0] === target_param) {
            has_target = true;
            parts[i] = target_param + '=' + target_value;
            break;
        }
    }
    if (!has_target) {
        parts.push(target_param + '=' + target_value);
    }
    //console.log(parts);
    let new_search = '?' + parts.join('&');
    if (window.location.hash !== '') {
        new_search += window.location.hash;
    }
    return new_search;
}


function switch_cgi_param_my() {
    let query = window.location.search.split('#')[0];
    let parts = [];
    if (query !== '') {
        parts = query.substring(1).split('&');
    }
    let has_my = false;
    for (let i=0; i<parts.length; ++i) {
        let fie_val = parts[i].split('=');
        if (fie_val[0] === 'my') {
            has_my = true;
            if (fie_val.length < 2 || fie_val[1] === '') {
                parts[i] = 'my=1';
            } else {
                parts[i] = 'my=';
            }
            break;
        }
    }
    if (!has_my) {
        parts.push('my=1');
    }
    //console.log(parts);
    let new_search = '?' + parts.join('&');
    if (window.location.hash !== '') {
        new_search += window.location.hash;
    }
    return new_search;
}
