
SIGNALS = {}

SIGNALS['div-search-5xx'] = {
    'templ': 'div(saas_unistat-search-{ctype}-{service}-5xx_dmmm, '
                'sum(saas_unistat-search-{ctype}-{service}-2xx_dmmm,'
                ' const(1)))',
    'itype': 'searchproxy',
    'limits_example': {'warn': 0.01, 'crit': 0.2, 'avgsec': 30}
}

SIGNALS['div-index-5xx'] = {
    'templ': 'div(saas_unistat-index-{ctype}-{service}-5xx_dmmm, '
                'sum(saas_unistat-index-{ctype}-{service}-2xx_dmmm,'
                ' const(1)))',
    'itype': 'indexerproxy',
    'limits_example': {'warn': 0.05, 'crit': 0.2, 'avgsec': 30}
}

SIGNALS['div-index-4xx'] = {
    'templ': 'div(saas_unistat-index-{ctype}-{service}-4xx_dmmm, '
                'sum(saas_unistat-index-{ctype}-{service}-2xx_dmmm,'
                ' const(1)))',
    'itype': 'indexerproxy',
    'limits_example': {'warn': 0.05, 'crit': 0.2, 'avgsec': 30}
}

SIGNALS['div-replics-inconsist'] = {
    'templ': 'aver~dm_dashboard-{ctype}-{service}-'
             'inconsistent-ratio_tvvv',
    'itype': 'deploymanager',
    'exclude_meta': True,
    'limits_example': {'warn': 0.05, 'crit': 0.2}
}

SIGNALS['cnt-replics-respond'] = {
    'templ': 'aver~dm_dashboard-{ctype}-{service}-'
             'respond_replics_tvvv',
    'itype': 'deploymanager',
    'exclude_meta': True,
    'limits_example': {'warn': 2.2, 'crit': 1.2}
}

SIGNALS['seconds-last-age'] = {
    'templ': 'aver~rty_infoserver-{service}-{ctype}-'
             'age_avvv',
    'itype': 'rtyserver',
    'exclude_meta': True,
    'limits_example': {'warn': 273600, 'crit': 360000}
}

SIGNALS['minutes-uptime'] = {
    'templ': 'aver~rty_infoserver-{service}-{ctype}-'
             'server_uptime-minutes_avvv',
    'itype': 'rtyserver',
    'exclude_meta': True,
    'limits_example': {'warn': 10, 'crit': 5}
}

SIGNALS['cnt-crashes'] = {
    'templ': 'crashes_log-saas_{ctype}-{service}_'
             'exit_signal_mmmm',
    'itype': 'rtyserver',
    'exclude_meta': True,
    'limits_example': {'warn': 0.02, 'crit': 0.05, 'avgsec': 180}
}

SIGNALS['cnt-max-sources'] = {
    'templ': 'rty_infoserver-{service}-{ctype}-'
             'search_sources_count_axxv',
    'itype': 'rtyserver',
    'exclude_meta': True,
    'limits_example': {'warn': 10, 'crit': 30, 'avgsec': 60}
}
