
TAG_NAMES = ('itype', 'ctype', 'prj', 'geo', 'tier')


class UserInput(object):
    SignalKey = ''
    CustomSignal = ''
    Service = ''
    Ctype = ''

    Limits = {}
    Users = []
    RealTags = {}
    Flaps = {}


class AlertInput(object):
    Signal = ''
    Limits = {}
    Users = []
    Flaps = {}
    RealTags = {}
    JugglerTags = []
    GolemHost = ''
    JugglerId = ''


class JugglerInput(object):
    GolemHost = ''
    JugglerId = ''
    GolovanIds = []
    Users = []
    Flaps = {}
    JugglerTags = []
    RingTimes = {}

    def to_json(self):
        result = {
            'host': self.GolemHost,
            'service': self.JugglerId,
            'refresh_time': 5,
            'aggregator': 'logic_or',
            'tags': self.JugglerTags,
            'namespace': 'search.saas',
            'children': [],
            'notifications': []
        }
        if self.Flaps:
            result['flaps'] = self.Flaps
        for child in self.GolovanIds:
            result['children'].append({
                'host': 'yasm_alert', 'type': 'HOST', 'instance': '',
                'service': child
            })
        result['notifications'].append({
            'template_name': 'golem',
            'template_kwargs': {},
            'description': ''})
        if self.RingTimes:
            result['notifications'][-1]['template_kwargs'].update(self.RingTimes)
        return result


class GolovanInput(object):
    Signal = ''
    GolovanId = ''
    RealTags = {}
    Limits = {}
    Descr = ''

    def to_json(self):
        result = {'name': self.GolovanId,
                  'signal': self.Signal,
                  'mgroups': ['ASEARCH'],
                  'description': self.Descr,
                  'tags': {}}
        if 'itype' not in self.RealTags:
            raise Exception('no itype tag for golovan found')
        for tag_name in TAG_NAMES:
            if tag_name in self.RealTags:
                result['tags'][tag_name] = self.RealTags[tag_name]
        result['warn'] = self.Limits['warn']
        result['crit'] = self.Limits['crit']
        if self.Limits.get('avgsec'):
            result['value_modify'] = {'type': 'aver', 'window': self.Limits['avgsec']}
        return result
