from django.core.mail import send_mail

import time
from time import localtime, strftime

MAILS_ADDRESS = 'saas-dm-configs@yandex-team.ru'


def send_dm_mail(subject, content):
    ts = int(time.time())
    time_hr = strftime('%X %x', localtime(ts))
    content += '\ntime: ' + time_hr + '\ntimestamp: ' + str(ts)
    try:
        send_mail(subject, content, 'saas-mon', [MAILS_ADDRESS])
        return {'success': True}
    except Exception as e:
        return {'success': False, 'error': '%s' % e}
