from saas_deploy.consts import IS_SAASDM_LOCAL


SAAS_COMMAND = [
    'aleksko',
    'alex0512',
    'anikella',
    'flyrise',
    'i024',
    'kniv',
    'saku',
    'salmin',
    'vbushev',
    'sarancev'
]


def my_services(slas, login):
    result = []
    for ctype, ctdata in slas.items():
        for service, sdata in ctdata.items():
            if login in [r.split('@')[0] for r in sdata.get('responsibles', [])]\
                    or login in [o.split('@')[0] for o in sdata.get('owners', [])]:
                result.append(service)
    return sorted(list(set(result)))


def is_saas_developer(login, with_local=True):
    return login in SAAS_COMMAND or (IS_SAASDM_LOCAL if with_local else False)
