from django.template.defaulttags import register


@register.filter
def get_item(dictionary, key):
    return (dictionary or {}).get(key)


@register.filter
def get_file_type(dictionary, key):
    try:
        return (dictionary.get(key) or {}).get('file_type', 'no file_type')
    except:
        return None


@register.filter
def get_task_id(dictionary, key):
    try:
        return (dictionary.get(key) or {}).get('task_id', 'no task_id')
    except:
        return None


@register.filter
def get_td_title(dictionary, key):
    if key not in dictionary:
        return 'no such file here'
    try:
        res = ''
        for field, value in dictionary[key].items():
            res += field + ': ' + str(value) + '\n'
        return res
    except Exception as e:
        return 'error %s' % e
