from django.conf.urls import url

from . import views
from . import views_alerts
from . import views_cluster
from . import views_deploy
from . import views_experrs
from . import views_storage
from . import views_yasm

# Uncomment the next two lines to enable the admin:
# from django.contrib import admin
# admin.autodiscover()

urlpatterns = [
    url(r'^ping', views.ping, name='ping'),
    url(r'^alerts_panel', views_alerts.alerts_panel, name='alerts_panel'),
    url(r'^alerts_status', views_alerts.status_alerts, name='status_alerts'),
    url(r'^alerts_clear', views_alerts.clear_alerts, name='clear_alerts'),
    url(r'^alerts', views_alerts.service_alerts, name='service_alerts'),
    url(r'^alert_post', views_alerts.post_alerts, name='set_alerts'),
    url(r'^alert_check', views_alerts.check_alerts, name='check_alerts'),
    url(r'^services', views.enter_service, name='main'),
    url(r'^get_ctypes', views.ctypes, name='get_ctypes'),
    url(r'^service_info', views.service_info, name='service_info'),
    url(r'^cluster_info_table', views_cluster.service_cluster_table, name='service_cluster_table'),
    url(r'^cluster_info', views.service_cluster_info, name='cluster_info'),
    url(r'^cluster_total_info_table', views_cluster.total_cluster_table, name='cluster_total_table'),
    url(r'^cluster_total_info', views_cluster.total_cluster_info, name='cluster_total'),
    url(r'^cluster_map_proxies', views_cluster.cluster_map_proxies, name='cluster_map_proxies'),
    url(r'^cluster_map_repshards', views_cluster.cluster_map_repshards, name='cluster_map_repshards'),
    url(r'^cluster_map', views_cluster.cluster_map, name='cluster_map'),
    url(r'^cluster_queues', views_cluster.cluster_queues, name='cluster_queues'),
    url(r'^storage_modify', views_storage.storage_modify, name='storage_modify'),
    url(r'^storage_versions', views_storage.storage_versions, name='storage_versions'),
    url(r'^storage_download', views_storage.download, name='storage_download'),
    url(r'^storage_remove', views_storage.remove, name='storage_remove'),
    url(r'^storage_fetch_fml', views_storage.storage_fetch_fml, name='storage_fetch_fml'),
    url(r'^storage', views_storage.storage, name='storage'),
    url(r'^diff_do', views_storage.config_diff_do, name='diff_do'),
    url(r'^diff', views_storage.config_diff, name='diff'),
    url(r'^endpoints_get', views_cluster.get_endpointset, name='endpoints_get'),
    url(r'^proxy', views_cluster.do_command_as_proxy, name='slot_proxy'),
    url(r'^slot_command', views_cluster.do_command_on_slot, name='slot_command'),
    url(r'^slots_restore', views_cluster.restore_slots, name='slots_restore'),
    url(r'^slots_replace', views_cluster.replace_slots, name='slots_replace'),
    url(r'^slots_release', views_cluster.release_slots, name='slots_release'),
    url(r'^eps_release', views_cluster.release_endpointsets, name='eps_release'),
    url(r'^replica_add', views_cluster.add_replica, name='add_replica'),
    url(r'^searchmap_modify', views_cluster.modify_searchmap, name='modify_searchmap'),
    url(r'^tags_info_modify', views_cluster.modify_tags_info, name='modify_tags_info'),
    url(r'^tags_info', views_cluster.tags_info, name='tags_info'),
    url(r'^polynom_converter', views.polynom_convertion, name='polynom_converter'),
    url(r'^nanny_info', views.nanny_info, name='nanny_info'),
    url(r'^deploy_tasks', views_deploy.deploy_tasks, name='deploy_tasks'),
    url(r'^deploy_trace', views_deploy.get_deploy_trace, name='deploy_trace'),
    url(r'^deploy_do', views_deploy.do_deploy, name='deploy_do'),
    url(r'^deploy_cancel', views_deploy.cancel_deploy, name='deploy_cancel'),
    url(r'^deploy_is_blocked', views_deploy.is_blocked_deploy, name='deploy_is_blocked'),
    url(r'^deploy_block', views_deploy.block_deploy, name='deploy_block'),
    url(r'^deploy', views.deploy_page, name='deploy_page'),
    url(r'^monitor_hosts', views_cluster.monitor_hosts, name='monitor_hosts'),
    url(r'^send_post/(?P<dm_url>[a-zA-Z0-9_&;.,/?:{}=*-]+)', views.post_impl, name='sendpost'),
    url(r'^monitor', views.monitor_gui, name='monitor_gui'),
    url(r'^sla_info', views.show_sla_table, name='sla_info'),
    url(r'^sla_set', views.set_sla, name='sla_set'),
    url(r'^sla_get', views.service_sla, name='sla_get'),
    url(r'^secret_keys', views.secret_keys, name='secret_keys'),
    url(r'^service_settings_edit', views.edit_service_cluster_settings, name='edit_service_settings'),
    url(r'^service_settings', views.service_cluster_settings, name='service_settings'),
    url(r'^update_caches', views.update_caches, name='update_caches'),
    url(r'^export_errors', views_experrs.export_errors, name='export_errors'),
    url(r'^golovan_index_rates', views_yasm.get_index_rates, name='index_rates'),
    url(r'^golovan', views_yasm.signals_digits, name='golovan'),
    url('', views.enter_service)

]
