from django.http import HttpResponse
from django.http import HttpResponseBadRequest
from django.shortcuts import render_to_response  # noqa

from .cluster import get_cluster_data as cluster
from .people import is_saas_developer
from . import people
from . import helpers
from . import mails

import json


def get_deploy_trace(request):
    task_id = request.GET.get('task_id')
    res = cluster.deploy_trace(task_id)
    return HttpResponse(json.dumps(res, indent=4), content_type='application/json')


def deploy_tasks(request):
    service = request.GET.get('service')
    ctype = request.GET.get('ctype')
    res = cluster.deploy_tasks(service, ctype)
    return HttpResponse(json.dumps(res))


def cancel_deploy(request):
    task_id = request.GET.get('task_id', '').strip()
    #  return HttpResponse(task_id)
    res = cluster.cancel_task(task_id)
    return HttpResponse(json.dumps(res))


def do_deploy(request):
    login = request.yauser.login if request.yauser.is_authenticated() else 'unauthorized'
    service = request.GET.get('service')
    ctype = request.GET.get('ctype')
    service_type = request.GET.get('service_type')
    slots = request.GET.get('slots')
    diff_only=request.GET.get('diff_only')

    if not is_saas_developer(login, with_local=True):
        slas_res = helpers.get_all_slas()
        if not slas_res['success']:
            return HttpResponseBadRequest(json.dumps({'error': 'cannot get sla logins', 'result': slas_res}))
        slas = slas_res['result']
        usr_services = people.my_services(slas, login)
        has_rights = service in usr_services
        if not has_rights:
            return HttpResponseBadRequest(json.dumps({'error': 'user ' + login + ' cannot do this', 'warnings': slas_res.get('warnings')}))

    deploy_url = cluster.build_deploy_command(service, ctype, service_type, 0.01, slots, diff_only, login=login)
    res = cluster.deploy(deploy_url)
    res['cmd'] = deploy_url
    mails.send_dm_mail('deploy ' + service + '-' + ctype + '-' + service_type,
                       'cmd=' + deploy_url + '\nlogin=' + login)
    return HttpResponse(json.dumps(res))


def is_blocked_deploy(request):
    service = request.GET.get('service')
    ctype = request.GET.get('ctype')
    res = cluster.is_deploy_blocked(service, ctype)
    return HttpResponse(json.dumps(res))


def block_deploy(request):
    login = request.yauser.login if request.yauser.is_authenticated() else 'unauthorized'
    service = request.GET.get('service')
    ctype = request.GET.get('ctype')
    reason = request.GET.get('reason')
    action = request.GET.get('action', 'set')

    if not is_saas_developer(login, with_local=True):
        slas_res = helpers.get_all_slas()
        if not slas_res['success']:
            return HttpResponseBadRequest(json.dumps({'error': 'cannot get sla logins', 'result': slas_res}))
        slas = slas_res['result']
        usr_services = people.my_services(slas, login)
        has_rights = service in usr_services
        if not has_rights:
            return HttpResponseBadRequest(json.dumps({'error': 'user ' + login + ' cannot do this', 'warnings': slas_res.get('warnings')}))

    res = cluster.deploy_block(service, ctype, login, reason, action)
    return HttpResponse(json.dumps(res))
