from django.http import HttpResponse  # noqa
from django.http import HttpResponseServerError, HttpResponseBadRequest  # noqa
from django.shortcuts import render_to_response

from .cluster import get_cluster_data as cluster

import datetime


def regroup_errors(res, service, ids, stat_services=False):
    export_err = []
    eid = 0
    err_desc = {}
    services = {}
    for host, errs in res.items():
        if not errs:
            continue
        for serv, docs in errs.items():
            for doc in docs:
                if stat_services:
                    srs = [doc.get('description', '').split(':')[0]]
                    for sr in srs:
                        services[sr] = services.get(sr, 0) + 1
                docs = [doc]
                if service:
                    docs = [doc for doc in docs[:] if doc.get('description', '').startswith(service)]
                if len(docs) == 0:
                    continue
                err = doc.get('reply')
                err_desc[err] = err_desc.get(err, [])
                count = 0
                if len(docs)>0:
                    time_last = docs[0].get('time_processed', 0)
                    count += len(docs)
                else:
                    time_last = 0
                for doc in docs:
                    try:
                        timedoc = datetime.datetime.fromtimestamp(doc.get('time_processed', 0))
                        doc['time_hr'] = timedoc.isoformat()
                    except:
                        pass
                err_desc[err].append({'docs': docs, 'host': host, 'time_last': time_last, 'count': count})
    for err, errdata in err_desc.items():
        errdata.sort(key=lambda x: x['time_last'], reverse=True)
        count = sum([ed.get('count', 0) for ed in errdata])
        export_err.append({'descr': err, 'docs': errdata, 'eid': 'err' + ids + str(eid),
                           'time_last': errdata[0].get('time_last'), 'count': count})
        export_err[-1]['time_last_hr'] = datetime.datetime.fromtimestamp(errdata[0].get('time_last', 0)).isoformat()
        eid += 1
    export_err.sort(key=lambda x: x['time_last'], reverse=True)
    return {'result': export_err, 'services': services}


def export_errors(request):
    service = request.GET.get('service', '')
    ctype = request.GET.get('ctype', '')
    res = {}

    df_res = {}
    try:
        df_res = cluster.get_docfetcher_errors(service, ctype).get('result', {})
    except:
        pass
    docf_err = []
    df_meta = {'count': 0}
    for serv in df_res:
        err_s_df = regroup_errors(df_res[serv], '', 'df'+serv).get('result')
        if err_s_df:
            docf_err.append({'service': serv, 'errors': err_s_df})
            df_meta['count'] += len(err_s_df)
    return render_to_response('errinfo.html', {'data': res,
                                               'df_errors': docf_err, 'df_meta': df_meta,
                                               'service': service, 'ctype': ctype})
