PY23_LIBRARY(saas_deploy)

PEERDIR(
    contrib/python/django/django-2.2
    contrib/python/simplediff
    infra/yasm/yasmapi
    library/python/django
    library/python/tvm2
    library/python/blackbox
    library/python/python-django-yauth

)

PY_SRCS(
   NAMESPACE saas_deploy
   consts.py
   helpers.py
   settings.py
   urls.py
   views.py
   views_alerts.py
   views_cluster.py
   views_deploy.py
   views_experrs.py
   views_storage.py
   views_yasm.py
   wsgi.py
   yasm_digits.py

   caches/__init__.py
   cluster/__init__.py
   cluster/addr.py
   cluster/alerts_commands.py
   cluster/get_cluster_data.py
   juggler/__init__.py
   juggler/alert_keys.py
   juggler/alerts.py
   juggler/backup.py
   juggler/dm.py
   juggler/formats.py
   juggler/golovan.py
   juggler/juggler.py
   juggler/token.py
   mails/__init__.py
   people/__init__.py

   templatetags/__init__.py
   templatetags/template_tags.py
)

RESOURCE_FILES(
  PREFIX saas_deploy/
   templates/alerts_main.html
   templates/alerts_panel.html
   templates/alerts_status.html
   templates/cluster_map.html
   templates/cluster_total_info.html
   templates/deploy.html
   templates/deploy_trace.html
   templates/diffs.html
   templates/enter_service.html
   templates/errinfo.html
   templates/files_info.html
   templates/monitor_custom.html
   templates/monitor_hosts.html
   templates/nav_ctype.html
   templates/navigation.html
   templates/polynom_converter.html
   templates/service_alerts.html
   templates/service_cluster_table.html
   templates/service_info.html
   templates/services_table.html
   templates/sla_table.html
   templates/storage.html

   static/chart.ico
   static/favicon_skull.ico

   static/css/font-awesome.min.css
   static/css/links.css
   static/css/navigation.css
   static/css/themes-tablesorter/blue/asc.gif
   static/css/themes-tablesorter/blue/bg.gif
   static/css/themes-tablesorter/blue/desc.gif
   static/css/themes-tablesorter/blue/style.css

   static/fonts/FontAwesome.otf
   static/fonts/fontawesome-webfont.eot
   static/fonts/fontawesome-webfont.svg
   static/fonts/fontawesome-webfont.ttf
   static/fonts/fontawesome-webfont.woff
   static/fonts/fontawesome-webfont.woff2
   static/fonts/glyphicons-halflings-regular.eot
   static/fonts/glyphicons-halflings-regular.svg
   static/fonts/glyphicons-halflings-regular.ttf
   static/fonts/glyphicons-halflings-regular.woff

   static/js/addr.js
   static/js/all_services_signal.js
   static/js/answer_set.js
   static/js/bootstrap3-typeahead.js
   static/js/cgi_switcher.js
   static/js/copying_link.js
   static/js/data_load.js
   static/js/jquery.metadata.js
   static/js/jquery.tablesorter.min.js
   static/js/xmlhttp.js

)

END()
