import time

from infra.yasm.yasmapi import GolovanRequest


def check_hosts(hosts_list, signals, period=5, points=3):
    NPTS = points
    data_period = period
    et = int(time.time())
    st = et - data_period * NPTS
    res = {}
    PORTION = 65
    for host in hosts_list:
        res[host] = []
        for i in range(int(len(signals) / PORTION) + 1):
            req = GolovanRequest(host, data_period, st, et, fields=signals[PORTION*i:min(PORTION*(i+1), len(signals))], explicit_fail=True)
            res[host].append([r for r in req])
    return res


if __name__ == 'main':
    pass
