# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

from backend.passport import passport_required
from flask import Blueprint, request, render_template
from cachetools import cached, TTLCache

import backend.models
from backend.helpers import BlueprintsHelpers

quotas = Blueprint('quotas', __name__)


@quotas.route('/<service_id>', methods=['GET'])
@cached(TTLCache(maxsize=512000, ttl=3600))
@passport_required
def show_service_quota(service_id):
    """
    Get service quotas table and prepare data for render
    """
    login = BlueprintsHelpers.get_user_login(request)
    service_quota_data = backend.models.AbcServiceQuota.load_quota(int(service_id))  # type: AbcServiceQuota

    return render_template(
        'quota_usage.html',
        title=u'Квоты сервисов',
        front_hostname=BlueprintsHelpers.get_front_hostname(),
        service_quotas_data=[service_quota_data, ],
        yandex_login=login,
        admin_mode=BlueprintsHelpers.is_saas_admin(login),
    )
