# -*- coding: utf-8 -*-

import logging
import requests

from saas.library.python.token_store import TokenStore


def get_current_duty():
    """
    Main method for getting current duty
    :return: type str
    """
    current_duty = ''
    warden_token = TokenStore.get_token_from_store_or_env('warden')
    try:
        r = requests.post(
            'https://warden.z.yandex-team.ru/api/warden.Warden/getComponent',
            json={'name': 'saas'},
            headers={'Authorization': "OAuth {}".format(warden_token)}
        )
        if r.ok:
            return r.json()['component']['dutyList']['onDuty'][0]['login']
        else:
            logging.error(r.text)
            raise RuntimeError
    except:
        logging.exception('Getting current duty FAILED')

    return current_duty
