# -*- coding: utf-8 -*-

from wtforms import StringField, SubmitField, SelectField, validators, RadioField, BooleanField
from wtforms.validators import DataRequired, StopValidation
from flask_wtf import FlaskForm
from saas.tools.ssm.SaaSServiceManager import SaaSServiceManager
from saas.library.python.deploy_manager_api.saas_service import SaasService

ctypes = SaaSServiceManager.ctype_tags.keys()


class DcChecker(object):
    def __init__(self, message=None):
        self.message = message

    def __call__(self, form, field):
        if not field.data:
            return
        for dc in field.data.replace(' ', '').split(','):
            if dc not in ['MAN', 'SAS', 'VLA', 'man', 'sas', 'vla']:
                raise StopValidation(self.message)


class ServiceExist(object):
    def __init__(self, message=None):
        self.message = message

    def __call__(self, form, field):
        service = field.data
        ctype = form.ctype.data
        sla_info = SaasService(ctype, service).sla_info
        if not sla_info or sla_info.keys() == ['owners', 'responsibles']:
            raise StopValidation(self.message)


class IsSelected(object):
    def __init__(self, msg_is_stable, msg_is_pre):
        self.message_if_stable = msg_is_stable
        self.message_if_prestable = msg_is_pre

    def __call__(self, form, field):
        kv_ot_ft = field.data
        if kv_ot_ft == "None" and form.ctype.data.split("_")[0] == "prestable":
            raise StopValidation(self.message_if_prestable)
        if kv_ot_ft != "None" and form.ctype.data.split('_')[0] == "stable":
            raise StopValidation(self.message_if_stable)


class FindkeyForm(FlaskForm):
    user_login = StringField('Yandex Login')
    service = StringField(u'Имя сервиса',
                          validators=[ServiceExist('Не удается получить информацию о данном сервисе в указанном ctype'),
                                      DataRequired(u'Укажите имя сервиса')])
    ctype = SelectField(u'Cluster type (ctype) сервиса',
                        choices=[tuple([ctype, ctype]) for ctype in ctypes],
                        validators=[DataRequired(u'Укажите ctype')],
                        description=u'Выберите cluster type сервиса.')
    url = StringField(u'Url документа который нужно найти',
                      validators=[DataRequired(u'Укажите url документа')],
                      description=u'Полный url документа который требуется найти')
    kps = StringField(u'Kps', default=0,
                      validators=[validators.Regexp(regex=r"^\d*$", message='Поле должно быть цлочисленным')],
                      description=u'Kps по которому требуется произвести поиск')
    use_tvm = BooleanField(u'Включить tvm-функциональность для хождения в бекенды',
                           default=False,
                           description=u'Включение tvm-функциональности для хождения в бекенды')
    src_tvm_id = StringField(u'Tvm id вашего сервиса ',
                             default=2011468,
                             validators=[validators.Regexp(regex=r"^\d*$", message='Поле должно быть цлочисленным')],
                             description=u'Укажите tvm-id своего сервиса, если получаете ошибки, связанные с tvm')
    dst_tvm_id = StringField(u'Ручной выбор searchproxy tvm-id',
                             validators=[validators.Regexp(regex=r"^\d*$", message='Поле должно быть цлочисленным')],
                             description=u'(advanced) Ручной выбор searchproxy tvm-id. Если опция не указана, тулза постарается угадать (и это должно работать)')
    yql_day_count = StringField(u'Временной период для поиска',
                                validators=[validators.Regexp(regex=r"^\d*$", message='Поле должно быть цлочисленным')],
                                default=0,
                                description=u'Целое число - количество дней до текущей даты, за которые нужно агрегировать данные логфеллера')
    yql_df_dst_table = StringField(u'Таблица для записи строк из docfetcher-лога',
                                   description=u'Таблица для записи строк из docfetcher-лога rtyserver')
    yql_index_dst_table = StringField(u'Таблица для записи строк из index-лога',
                                      description=u'Таблица для записи строк из index-лога rtyserver')
    ferryman_host = StringField(u'Хост Ferryman для использования',
                                description=u'Хост Ferryman для использования вместо автоматически определяемого')
    ferryman_show_found = BooleanField(u'Выводить все таблицы Ferryman ytpull',
                                       default=False,
                                       description=u'Выводить все таблицы Ferryman ytpull, даже те, в которых не был найден документ')
    ignore_dc = StringField(u'Исключать датацентры при обходе бэкендов',
                            render_kw={"placeholder": "Например: man, sas"},
                            validators=[DcChecker('Пожалуйста, укажите локацию(-и) из списка: man, sas, vla')],
                            description=u'Датацентры, которые следует исключать при обходе бэкендов (через запятую, маленькими буквами)')
    kv_or_ft = RadioField(u'Является ли сервис key-value или полнотекстовым',
                          choices=[('None', 'not_stated'), ('ft', 'full_text'), ('kv', 'key_value')],
                          default='None',
                          description=u'Возможность указать, что сервис является kv-сервисом')
    submit = SubmitField(u'Отправить')
