# -*- coding: utf-8 -*-

from wtforms import StringField, SubmitField, SelectField, TextAreaField, validators
from wtforms.validators import DataRequired
from flask_wtf import FlaskForm


from service_validators import CountOf


class NamespaceForm(FlaskForm):
    user_login = StringField('Yandex Login')
    namespace_name = StringField(u'Имя неймспейса',
                                 validators=[DataRequired(u'Укажите имя неймспейса')],
                                 description=u'Имя неймспейса может состоять только из латинских букв. '
                                             u'Разрешается добавление суффикса через двоеточие. '
                                             u'SSM не добавляет суффикс автоматически, указывайте '
                                             u'":docid_setprops" или другой суффикс явно.'
                                 )

    owners_list = StringField(u'Список ответственных',
                              validators=[DataRequired(u'Поле не может быть пустым'),
                                          validators.Regexp(
                                              regex=r'^[^@]+$',
                                              message='Логин пользователя не должен содержать символа @')
                                          ],
                              description=u'Список логинов со staff, за которыми будет закреплен '
                                          u'сервис. Логины перечисляются через запятую. Пример: '
                                          u'user1, user2, user3'
                              )
    ferryman_service = SelectField(u'Коммунальный сервис',
                                   choices=[('fastsnips', 'fast_snippets'), ('rankingmid', 'ranking_mid'),
                                            ('querydata', 'query_data'), ('fast_query_data', 'fast_query_data')],
                                   default='fast_snippets',
                                   description=u'Выберите тип коммунальный сервис из списка')
    ferryman_ctype = StringField(u'Ctype коммунального сервиса',
                                 description=u'Cluster type коммунального сервиса',
                                 default='stable_middle_kv',
                                 validators=[DataRequired(u'Поле не может быть пустым')],
                                 render_kw={"placeholder": "Например: stable_middle_kv"})
    namespace_size = StringField(u'Размер неймспейса',
                                 description=u'Общий объём документов находящихся в сервисе (можно посмотреть, например, '
                                             u'на данные в YT).'
                                             u'Поддерживаются сокращения: Kb - килобайты, Mb - мегабайты, Gb - гигабайты, Тb - терабайты',
                                 validators=[DataRequired(u'Поле не может быть пустым'),
                                             CountOf('bytes', message='Неверный формат ввода данных')],
                                 render_kw={"placeholder": "Например: 5Gb"})

    namespace_doccount = StringField(u'Количество документов',
                                     description=u'Максимальное количество документов (или объектов для kv-storage). '
                                                 u'Поддерживаются сокращения: K - тысячи, М - миллионы, B - миллиарды',
                                     validators=[DataRequired(u'Поле не может быть пустым'),
                                                 CountOf('decimal', message='Неверный формат ввода данных')],
                                     render_kw={"placeholder": "Например: 10M"})

    comment = TextAreaField(u'Комментарий',
                            validators=[DataRequired(u'Поле не может быть пустым')],
                            description=u'Опишите здесь назначение сервиса, пожелания и комментарии.'
                            )

    submit = SubmitField(u'Отправить')
