# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

import socket
import backend.startrek_issues


class BlueprintsHelpers(object):
    _saas_administrators = None
    _front_hostname = None

    @staticmethod
    def get_user_login(req):
        return req.cookies.get('yandex_login', 'anonymous')

    @classmethod
    def get_front_hostname(cls):
        if cls._front_hostname is None:
            cls._front_hostname = socket.gethostname()
        return cls._front_hostname

    @classmethod
    def get_saas_administrators(cls):
        if cls._saas_administrators is None:
            cls._saas_administrators = backend.startrek_issues.abc_client.get_logins_by_role('664', 'administration')
        return cls._saas_administrators

    @classmethod
    def is_saas_admin(cls, login):
        if login in cls.get_saas_administrators() or login == 'anonymous':
            return True
        else:
            return False
