import logging
import requests


class SaasAbcdConnector(object):
    API_HOSTNAME = "http://abcd.saas.yandex.net"

    @classmethod
    def __getter(cls, path):
        response = requests.get("{}/api/saas/{}".format(cls.API_HOSTNAME, path))
        if not response.ok:
            logging.error(response.reason)
            return {}
        return response.json()

    @classmethod
    def get_quotas(cls):
        return cls.__getter("quotas")

    @classmethod
    def get_quota(cls, abc_id):
        return cls.__getter("quotas/{}".format(abc_id))

    @classmethod
    def get_saas_services(cls, abc_quota_id=None):
        if not abc_quota_id:
            return cls.__getter("services")
        return cls.__getter("services/{}".format(abc_quota_id))
