PY2_LIBRARY()

OWNER(saku)

PEERDIR(
    contrib/python/Flask
    contrib/python/Flask-WTF
    contrib/python/WTForms
    contrib/python/Jinja2
    contrib/python/gunicorn
    contrib/python/six
    yt/python/client
    contrib/python/cachetools
    library/python/svn_version
    library/python/blackbox
    library/python/tvm2
    saas/tools/ssm
    saas/tools/devops/lib23
    saas/library/persqueue/common/python
    saas/library/python/byte_size
    saas/library/python/singleton
    saas/library/python/token_store
    saas/library/python/sandbox
    saas/library/python/deploy_manager_api
    saas/library/python/errorbooster
    saas/library/python/saas_ctype
    saas/library/python/awacs
    saas/library/python/bundle_networks
)

PY_SRCS(
    NAMESPACE backend
    ssm.py
    yt_cypress.py
    shooting.py
    ssm_worker.py
    startrek_issues.py
    daemon.py
    duty.py
    helpers.py
    passport.py
    manage_requests.py
    models.py
    quotas.py
    resources_calculation.py
    blueprints/__init__.py
    blueprints/ping_page.py
    blueprints/quotas.py
    blueprints/ssm_viewer_page.py
    forms/__init__.py
    forms/service_form.py
    forms/namespace_form.py
    forms/service_validators.py
    forms/shooting_form.py
    forms/findkey_form.py
)

RESOURCE(
    templates/quota_usage.html /jinja/quota_usage.html
    templates/common.html /jinja/common.html
    templates/form.html /jinja/form.html
    templates/findkey.html /jinja/findkey.html
    templates/findkey_templates.html /jinja/findkey_templates.html
    templates/macro.html /jinja/macro.html
    templates/new.html /jinja/new.html
    templates/new_namespace.html /jinja/new_namespace.html
    templates/requests.html /jinja/requests.html
    templates/shoot_to_service.html /jinja/shoot_to_service.html
    static/favicon.ico /static/favicon.ico
    static/vonny.jpg /static/vonny.jpg
)

NO_CHECK_IMPORTS()

END()

RECURSE_FOR_TESTS(
    tests
)
