#include "cluster.h"

#include <saas/util/external/dc.h>
#include <library/cpp/logger/global/global.h>

namespace NRTYCluster {

    TCTypeCluster::TPtr TCTypeCluster::FilterSlots(const ISlotsFilter& filter) const {
        TCTypeCluster::TPtr result = new TCTypeCluster();
        TReadGuard rg(Mutex);
        TMap<TString, TDatacenter> filteredSlots = filter.Apply(DCs);
        if (filteredSlots.size() == 0)
            return new TCTypeCluster();

        for (auto&& dc : filteredSlots) {
            for (auto&& slot : dc.second.GetSlots()) {
                result->RegisterSlot(slot.second);
            }
        }
        return result;
    }
}
