#include "cluster.h"
#include "datacenter.h"

#include <saas/util/external/dc.h>

namespace NRTYCluster {

    void TDatacenter::ScanAll(IClusterScanCallback& callback) const {
        for (TMap<TString, TSlotData>::const_iterator i = Slots.begin(); i != Slots.end(); ++i) {
            callback.OnSlot(i->first, i->second);
        }
    }

    const TString TDatacenter::SASMarker = "SAS";
    const TString TDatacenter::MSKMarker = "MSK";
    const TString TDatacenter::MANMarker = "MAN";
    const TString TDatacenter::VLAMarker = "VLA";
}
