#include "filters.h"
#include "datacenter.h"
#include "server.h"

namespace NRTYCluster {
    TMap<TString, TDatacenter> TFiltersCollection::Apply(const TMap<TString, TDatacenter>& dcs) const {
        TMap<TString, TDatacenter> result = dcs;
        for (auto&& filter : Filters) {
            TMap<TString, TDatacenter> tmp;
            tmp.swap(result);
            result = filter->Apply(tmp);
            for (auto&& dc : tmp)
                INFO_LOG << tmp[dc.first].GetSlots().size() - (result.contains(dc.first) ? result[dc.first].GetSlots().size() : 0) << " slots filtered for dc " << dc.first << Endl;
        }
        return result;
    }
}
