#pragma once

#include "slot_data.h"
#include "server.h"
#include <util/generic/ptr.h>
#include <library/cpp/logger/global/global.h>

namespace NRTYCluster {

    class TDatacenter;

    class ISlotsFilter {
    public:

        using TPtr = TAtomicSharedPtr<ISlotsFilter> ;

        virtual ~ISlotsFilter() {}

        virtual TMap<TString, TDatacenter> Apply(const TMap<TString, TDatacenter>& dcs) const = 0;
    };

    class TFiltersCollection: public ISlotsFilter {
    private:
        TVector<ISlotsFilter::TPtr> Filters;
    public:
        void RegisterFilter(ISlotsFilter::TPtr filter) {
            Filters.push_back(filter);
        }

        virtual TMap<TString, TDatacenter> Apply(const TMap<TString, TDatacenter>& dcs) const override;
    };
}
