#pragma once
#include "slot_data.h"

#include <util/generic/string.h>
#include <util/string/cast.h>
#include <util/generic/map.h>
#include <util/string/vector.h>
#include <util/system/mutex.h>
#include <util/generic/set.h>
#include <util/digest/fnv.h>
#include <library/cpp/cgiparam/cgiparam.h>
#include <util/charset/utf8.h>
#include <util/charset/wide.h>
#include <library/cpp/json/writer/json_value.h>

namespace NRTYCluster {

    class ISlotsFilter;

    class TServer {
    private:
        TMap<TString, TSlotData> Slots;
    public:
        TServer() {

        }

        bool IsExists(const TSlotData& slot) const {
            return Slots.find(slot.ShortSlotName()) != Slots.end();
        }

        const TMap<TString, TSlotData>& GetSlots() const {
            return Slots;
        }

        bool RegisterSlot(const TSlotData& slot) {
            if (!IsExists(slot)) {
                Slots[slot.ShortSlotName()] = slot;
                return true;
            }
            else {
                return false;
            }
        }

        bool Deserialize(const NJson::TJsonValue& json) {
            if (!json.IsMap())
                return false;

            Slots.clear();
            for (auto&& i : json.GetMapSafe()) {
                if (!Slots[i.first].Deserialize(i.second)) {
                    return false;
                }
            }
            return true;
        }

        NJson::TJsonValue Serialize() const {
            NJson::TJsonValue result(NJson::JSON_MAP);
            for (auto&& i : Slots) {
                result[i.first] = i.second.Serialize();
            }
            return result;
        }
    };
}
