#include "slot_data.h"

#include <library/cpp/logger/global/global.h>
#include <library/cpp/testing/unittest/registar.h>

namespace {
    void InitLog() {
        if (!GlobalLogInitialized())
            DoInitGlobalLog("console", 7, false, false);
    }
}

Y_UNIT_TEST_SUITE(TRtySlotsDataTest) {
    Y_UNIT_TEST(SlotsDataParse) {
        InitLog();
        NRTYCluster::TSlotData sd;
        UNIT_ASSERT(NRTYCluster::TSlotData::Parse("host:1234", sd));
        UNIT_ASSERT_EQUAL(sd.Port, 1234);
        UNIT_ASSERT_EQUAL(sd.FullHost(), "host");

        UNIT_ASSERT(!NRTYCluster::TSlotData::Parse("host:1234:", sd));
        UNIT_ASSERT(!NRTYCluster::TSlotData::Parse("host:zzz", sd));
        UNIT_ASSERT(!NRTYCluster::TSlotData::Parse("host", sd));
    }
}
