#pragma once

#include <util/generic/yexception.h>
#include <util/stream/str.h>

class TCodedException : public yexception {
public:
    TCodedException(int code)
        : Code(code)
    {}

    int GetCode() const {
        return Code;
    }

private:
    int Code;
};

class TCodedError {
public:
    static const int OK = 200;

    TCodedError(int code = OK)
        : Code(code)
    {}

    template <class T>
    inline TCodedError& operator<<(const T& t) {
        Message << t;
        return *this;
    }

    inline int GetCode() const {
        return Code;
    }

    inline const TString& GetMessage() const {
        return Message.Str();
    }

    inline bool IsOk() const {
        return Code == OK;
    }
private:
    int Code;
    TStringStream Message;
};
