#pragma once


#include <util/generic/string.h>
#include <util/generic/map.h>
#include <util/generic/singleton.h>
#include <util/generic/hash.h>
#include <util/string/vector.h>
#include <util/system/mutex.h>
#include <util/system/rwlock.h>

#define ALIAS_NOT_DEFINED "NO_ALIAS"
#define DC_NOT_DEFINED "NO_DC"
#define HOST_NOT_DEFINED "NO_HOST"

namespace NSlotNameUtil {
    inline TString ShortHost(const TString& host) {
        return host;
    }

    static const TMap<TString, TString> Cluster2DC = {
        {"man", "MAN"},
        {"sas", "SAS"},
        {"vla", "VLA"},
        {"iva", "MSK"},
        {"myt", "MSK"},
        {"man-pre", "MAN"},
        {"sas-test", "SAS"}
        };

    inline TString DCFromEndpointSet(const TString& epSet) {
        const TString clusterName = SplitString(epSet, "@")[0];
        return Cluster2DC.contains(clusterName) ? Cluster2DC.at(clusterName) : "";
    }

    inline bool IsNormalDC(const TString& dc) {
        return (dc != DC_NOT_DEFINED && dc != "" && dc != "null");
    }
}

class TDatacenterUtil {
    Y_DECLARE_SINGLETON_FRIEND()
public:
    virtual ~TDatacenterUtil() {}
    bool SetDatacenter(const TString& host, const TString& value);
    TString GetDatacenter(const TString& host);

    bool AddDatacenterAlias(const TString& dc, const TString& alias);
    bool GetDatacenterAlias(const TString& dc, TString& result);
    TString GetDatacenterAlias(const TString& dc);

    bool SetRealHost(const TString& host, const TString& value);
    TString GetRealHost(const TString& host);

    bool SetPodIP(const TString& fqdn, const TString& ip);
    TString GetPodIP(const TString& fqdn);

    void SetApiHost(const TString& value) {
        ApiHost = value;
    }
    void SetApiUrl(const TString& value) {
        ApiUrl = value;
    }
    bool IsInitialized() const {
        return (!!ApiHost && !!ApiUrl) || (ApiHost == "local");
    }
    static TDatacenterUtil& Instance();
private:
    typedef TMap<TString, TString> TDatacenterAliases;
    TDatacenterUtil() {
        AddDatacenterAlias(DC_NOT_DEFINED, ALIAS_NOT_DEFINED);
    }
private:
    TDatacenterAliases AliasByFullNameMap;
    TString ApiHost = "local";
    TString ApiUrl;
    TRWMutex Mutex;
    THashMap<TString, TString> DCByHost;
    THashMap<TString, TString> RealHostByContainer;
    THashMap<TString, TString> IPByPod;
};
