#pragma once

#include <util/generic/string.h>
#include <library/cpp/json/json_reader.h>
#include <library/cpp/json/json_writer.h>
#include <util/folder/path.h>
#include <util/folder/filelist.h>
#include <util/system/execpath.h>
#include <util/stream/file.h>
#include <library/cpp/digest/md5/md5.h>
#include <util/system/shellcommand.h>

namespace NRTY {
    class TDiffBuilder {
    private:

    public:
        static TString Calc(const TString& s1, const TString& s2) {
#ifdef _win_
            TStringStream ss;
            ss << "<table cellspcing=\"2\" cellpadding=\"2\" border=\"1\"><tr><td>" << s1 << "</td><td>" << s2 << "</td></tr>";
            ss << "</table>";
            return ss;
#else
            TFsPath path(GetExecPath());
            TFsPath path1 = path.Dirname() + "/" + MD5::Calc(s1 + ToString(Now().MicroSeconds()) + ToString(rand()));
            TFsPath path2 = path.Dirname() + "/" + MD5::Calc(s2 + ToString(Now().MicroSeconds()) + ToString(rand()));
            {
                TUnbufferedFileOutput fo1(path1);
                TUnbufferedFileOutput fo2(path2);
                fo1 << s1;
                fo2 << s2;
            }
            TShellCommandOptions options;
            options.SetClearSignalMask(true);
            options.SetCloseAllFdsOnExec(true);
            TShellCommand cmd("diff -u " + path1.GetPath() + " " + path2.GetPath(), options);
            cmd.Run();
            cmd.Wait();
            path1.DeleteIfExists();
            path2.DeleteIfExists();
            return cmd.GetOutput();
#endif
        }
    };
}
